# -*- coding: utf-8 -*-

from __future__ import (
    absolute_import,
    unicode_literals,
)

from argparse import FileType as ArgParseFileType
import logging
from signal import (
    SIGTTIN,
    SIGTTOU,
)

from passport.backend.core.conf import settings
from passport.backend.core.env import Environment
from passport.backend.dbscripts.split_phonenumber_alias import settings as local_settings
from passport.backend.dbscripts.split_phonenumber_alias.base import split_phonenumber_aliases
from passport.backend.dbscripts.utils import (
    EntryPoint,
    Throttler,
    ThrottlerControl,
)
from passport.backend.utils.common import chop


log = logging.getLogger('passport.backend.dbscripts.split_phonenumber_alias')


def run(uids=None, _file=None):
    if not uids and _file:
        uids = _file

    throttler = Throttler(rps=float(settings.DATABASE_WRITE_LOAD_PER_SECOND) / settings.UIDS_IN_BLACKBOX_REQUEST)

    throttler_control = ThrottlerControl(
        throttler,
        decrease_signum=SIGTTIN,
        increase_signum=SIGTTOU,
    )
    throttler_control.setup()

    for chunk in chop(uids, settings.UIDS_IN_BLACKBOX_REQUEST):
        throttler.throttle()
        split_phonenumber_aliases(chunk, Environment())


class Main(EntryPoint):
    LOCK_NAME = '/passport/split_phonenumber_alias/global_lock'
    SETTINGS = local_settings

    def run(self, args):
        run(args.uids, args.file)

    def get_arg_parser(self):
        parser = super(Main, self).get_arg_parser()
        parser.add_argument('--uids', nargs='*', type=int, default=[], metavar='uid')
        parser.add_argument('--from', dest='file', metavar='path', type=ArgParseFileType('r'))
        return parser


main = Main()
