PY3_LIBRARY(passport_db_scripts)

OWNER(
    g:passport_python
)

NEED_REVIEW()

IF (NOT OS_WINDOWS)

PEERDIR(
    contrib/python/Jinja2
    contrib/python/mysqlclient

    library/python/yenv

    passport/backend/api/settings
    passport/backend/api/templates
    passport/backend/core
    passport/backend/utils
)

PY_SRCS(
    __init__.py
    context.py
    logging.py
    settings.py
    templating.py
    utils.py
)

ENDIF()

END()

IF (NOT OS_WINDOWS)
RECURSE(
    account_deleter
    delete_expired_support_codes
    delete_expired_family_invites
    hide_my_social_display_name
    load_mail_unsubscriptions
    persistent_tracks_cleaner
    phone_harvester
    phone_bindings_history_cleaner
    phone_number_translator
    randoms_generator
    reserved_logins_cleaner
    social_data_deleter
    split_phonenumber_alias
    test
    yakey_backups_cleaner
)

RECURSE_FOR_TESTS(
    tests
)
ENDIF()
