# -*- coding: utf-8 -*-
import logging

from passport.backend.core.dbmanager.manager import safe_execute_queries
from passport.backend.dbscripts.utils import EntryPoint
from passport.backend.dbscripts.yakey_backups_cleaner import settings as local_settings
from passport.backend.dbscripts.yakey_backups_cleaner.db import YakeyBackupsCleanupQuery


log = logging.getLogger('passport.backend.dbscripts.yakey_backups_cleaner')


def clean_up_expired_backups(offset, phone_numbers=None):
    log.info('Start deleting expired yakey backups')
    query = YakeyBackupsCleanupQuery(offset=offset, phone_numbers=phone_numbers)
    deletion_result = {}

    def _callback(result):
        deletion_result['count'] = result.rowcount

    safe_execute_queries([(query, _callback)])
    log.info('Finished deleting expired yakey backups. Total count %d', deletion_result['count'])


class Main(EntryPoint):
    LOCK_NAME = '/passport/yakey_backups_cleaner/global_lock'
    SETTINGS = local_settings

    def run(self, args):
        clean_up_expired_backups(
            local_settings.YAKEY_BACKUP_EXPIRATION_PERIOD,
            phone_numbers=args.phone_numbers,
        )

    def get_arg_parser(self):
        parser = super(Main, self).get_arg_parser()
        parser.add_argument('--phone_numbers', nargs='*', type=int, default=[], metavar='phone_numbers')
        return parser


main = Main()
