# -*- coding: utf-8 -*-
from datetime import (
    datetime,
    timedelta,
)

from passport.backend.core.db.schemas import yakey_backups_table
from passport.backend.core.serializers.query import GenericQuery
from sqlalchemy.sql.expression import and_


class YakeyBackupsCleanupQuery(GenericQuery):
    def __init__(self, offset=None, phone_numbers=None):
        super(YakeyBackupsCleanupQuery, self).__init__(
            table=yakey_backups_table,
            data=None,
        )
        self.offset = offset or timedelta(days=365)
        self.phone_numbers = phone_numbers

    def to_query(self):
        expired_before = datetime.now() - self.offset
        cond = and_(self.table.c.updated <= expired_before)
        if self.phone_numbers:
            cond = and_(cond, self.table.c.phone_number.in_(self.phone_numbers))
        return self.table.delete().where(cond)
