# Dev-окружение паспорта

Пока поддерживается только passport API.
Все инструкции по установке - для Ubuntu.

## Возможности
* Настроить при помощи Ansible dev-машину, на которой запускается паспортное API
* Запускать автотесты API на dev-машине (под капотом они работают в docker)
* Запускать Docker-контейнеры с паспортным API, с возможностью подмены бинарника или пакета, на заданном порту

### Общие требования
* Настроить ssh agent текущему пользователю
```bash
# записать в .bash_profile:
if [ -z "$SSH_AUTH_SOCK" ] ; then
  eval `ssh-agent -s`
  ssh-add
fi
# Проверить, что ключ добавлен. Должен выдаться командой
ssh-add -l
```

## Настройка dev-машины с помощью Ansible
### Описание
Настраивается текущая машина, на неё ставятся все пакеты, нужные для запуска api. Также ставится redis.
БД будет использоваться внешняя тестовая.

### Требования
* Текущий пользователь должен иметь sudo-права
### Запуск
От обычного пользователя
```bash
passport-dev-env-configure-api
```

## Запуск автотестов API на dev-машине
### Описание
Команда:
```
passport-autotests-api --help
```
Собирает API из текущего состояния локальной копии репозитория, кладёт его в docker-контейнер, затем на контейнер
натравливаются автотесты. \
Контейнер собирается не на каждый запуск, а только при необходимости или если это запрошено аргументом команды. \
Старые контейнеры автотестов удаляются перед сборкой нового.


### Требования
* Текущая dev-машина настроена (см. "Настройка dev-машины с помощью Ansible")

### Запуск тестов
* Запускать от обычного пользователя.
* Запускать нужно в директории с тестами, как ya make -tt (или run_tests.sh).
* Аргументы для ya make можно писать в конец команды.
* Если нужно включить в бинарник новые локальные не закоммиченные изменения, добавить ключ --rebuild-api
* Если обновились гранты, либо почему-то ещё нужно включить в контейнер новые версии пакетов зависимостей, добавить ключ --rebuild-all

### ТТХ
* Тестовое API слушает на *:10361
* Логи лежат внутри контейнера (passport-autotests-api --shell) в директории /app

Варианты запуска:
```bash
# Запустить все тесты
passport-autotests-api

# Запустить с фильтром
passport-autotests-api -F test_something.py::SomeTestSuit::test_something_ok

# Запустить с пересборкой API
passport-autotests-api --rebuild-api

# Запустить с пересборкой всего контейнера
passport-autotests-api --rebuild-all
```

### Просмотр логов вывода API
Выводятся логи stdout/stderr api. API в текущем состоянии работает в контейнере в debug режиме.\
К команде можно добавить в конец аргументы docker logs

Варианты запуска
```bash
# Просто вывести логи
passport-autotests-api --logs

# Посмотреть help по аргументам docker logs
passport-autotests-api --logs --help

# Использовать аргументы docker logs
# например: тейлить в реальном времени (как tail -f)
passport-autotests-api --logs -f
# например: вывести последние 100 строк
passport-autotests-api --logs -n 100
```

### Подключение к docker в интерактивном режиме
Подключение к консоли, в которой запущен API (под капотом это docker attach)\
Отключиться можно комбинацией Ctrl+[

```bash
passport-autotests-api --attach
```

### Открытие bash-консоли в docker с API
Например, чтобы посмотреть в ней логи из файлов, что-то подебажить, посмотреть\
Логи лежат в /app

```bash
passport-autotests-api --shell
```


## Запуск Docker-контейнера с API
### Описание
Контейнеры запускаются автоматически, в них будет содержаться пакет yandex-passport-api и необходимые зависимости,
кроме Redis и геоданных. Redis и геоданные должны быть на хост-машине.
Настроить redis и скачать геоданные можно, настроив dev-машину ansible'ом.

Базовые зависимости будут собираться один раз, а затем использоваться из кеша, если не указать флаг -r (rebuild).

Порт указывается при запуске, либо используется 4000. Слушается на localhost, доступен с хост-машины.

Отсоединение от контейнера производится комбинацией **ctrl+[**.
Можно запустить контейнер сразу в бэкграунде флагом -d.

### Требования
* Установить docker.io, добавить своего юзера в группу docker Рекомендуется использовать **"Настройку dev-машины с помощью Ansible"**
* Настроить redis. Рекомендуется использовать **"Настройку dev-машины с помощью Ansible"**
* Скачать геоданные. Рекомендуется использовать **"Настройку dev-машины с помощью Ansible"**

### Примеры запуска:
Запускать от обычного пользователя.
Команда - **passport-docker-api**. Все аргументы можно посмотреть, запустив с -h.
Последний аргумент (bin/package/base) - это способ запуска.
* Собственный бинарник _~/my-passport-api_, порт 4005
```bash
passport-docker-api -f ~/my-passport-api -p 4005 bin
```
* Собственный пакет _~/my-passport-api.deb_, порт по умолчанию (4000), тег по умолчанию (package)
```bash
passport-docker-api -f ~/my-passport-api.deb package
```
* Запуск с самым новый пакетом yandex-passport-api из паспортных репозиториев:
аргумент **-r** пересоберёт базовый образ и установит последнюю версию
```bash
passport-docker-api -r base
```

### Продвинутое использование
Все контейнеры строятся из базового Docker-образа **passport-api-dev-base:1**, который в большей части случаев лежит в
кеше и перестраивается в основном только по флагу -r.
В нём настроены репозитории Yandex и passport*, установлены гласные и негласные зависимости passport-api.

Поверх базового образа раскатывается образ с подменным бинарником или подменным пакетом.
Конечный образ называется **passport-api-dev-run:TAG**, где TAG задаётся аргументом команды,
а по умолчанию означает способ запуска (bin/package).

Таким образом, можно создавать собственные образы из нужной ветки с собственным тегом, и хранить сколько нужно,
параллельно с текущим.
Но за ними нужно будет следить вручную и чистить при необходимости.
Автоматический же **passport-api-dev-run:(bin|package)** будет всегда один.

### Примеры продвинутого использования
* Запуск с собственным бинарником _~/my-passport-api_, порт 4005, тэг my-branch
```bash
passport-docker-api -f ~/my-passport-api -p 4005 -t my-branch bin
```
* Посмотреть запущенные контейнеры
```bash
$ docker ps

CONTAINER ID   IMAGE                            COMMAND                  CREATED          STATUS          PORTS     NAMES
3000f64bac1e   passport-api-dev-run:my-branch   "/bin/sh -c /app/run…"   16 seconds ago   Up 15 seconds             zen_newton
```
* Подключиться к запущенному контейнеру 3000f64bac1e.
Предлагаю использовать --detach-keys="ctrl-[", потому что по умолчанию в докере ctrl+p, ctrl+q почему-то не всегда работает
```bash
docker attach --detach-keys="ctrl-[" 3000f64bac1e
```
* Остановить контейнер 3000f64bac1e
```bash
docker stop 3000f64bac1e
```
* Залистить конечные образы Docker
```bash
$ docker stop 3000f64bac1e | grep passport-api-dev-run
passport-api-dev-run    my-branch   23bfbe20d664   4 hours ago    3.17GB
passport-api-dev-run    test        23bfbe20d664   4 hours ago    3.17GB
passport-api-dev-run    bin         f867e28246fb   10 hours ago   3.17GB
```
* Удалить образ passport-api-dev-run с тегом my-branch
```bash
docker image rm passport-api-dev-run:my-branch
```
