#!/bin/bash

ssh-add -l > /dev/null || {
   echo "Please setup ssh agent forwarding first"
   echo "e.g. 'ssh-agent -s; ssh-add'"
   echo "ssh-add -l should display your key(s)"
   exit 1
}

which ansible-playbook > /dev/null || {
    echo "Please install ansible first"
    exit 1
}

if [ $# -gt 0 ]; then
    echo "Setups server to run passport API"
    echo "No args required"
    exit 1
fi

echo "--- Executing ansible playbook for passport API"
ansible-playbook "$(dirname $(realpath $0))/ansible/passport_api.yml"
