package blackboxadapter

import (
	"context"

	"a.yandex-team.ru/library/go/core/log"
	"a.yandex-team.ru/passport/backend/federal_config_api/internal/core/interfaces"
	"a.yandex-team.ru/passport/backend/federal_config_api/internal/logutils"
)

type blackboxAdapter struct {
	logger log.Logger
}

// compile-time проверка, что интерфейс имплементирован корректно
var _ interfaces.PDDAdapter = (*blackboxAdapter)(nil)

func NewBlackboxAdapter(logger log.Logger) (*blackboxAdapter, error) {
	return &blackboxAdapter{logger: logger}, nil
}

func (ba *blackboxAdapter) logDebugf(ctx context.Context, msg string, args ...interface{}) {
	if ba.logger != nil {
		logutils.AddCommonFromContext(ctx, ba.logger).Debugf(msg, args...)
	}
}

func (ba *blackboxAdapter) Exists(ctx context.Context, domainIDs []uint64) (bool, error) {
	ba.logDebugf(ctx, "Domain IDs %v exist", domainIDs)
	return true, nil
}
