package pgadapter

type DiffUInt64 struct {
	ToAdd    []uint64
	NoChange []uint64
	ToRemove []uint64
}

func utilDiffDomainIDs(old []uint64, new []uint64) DiffUInt64 {
	// O(n) диффалка между двумя несортированными последовательностями
	oldItems := map[uint64]struct{}{}
	keepItems := map[uint64]struct{}{}

	toAdd := []uint64{}
	noChange := []uint64{}
	toRemove := []uint64{}

	for _, oldItem := range old {
		oldItems[oldItem] = struct{}{}
	}
	for _, newItem := range new {
		_, found := oldItems[newItem]
		if found {
			keepItems[newItem] = struct{}{}
			noChange = append(noChange, newItem)
		} else {
			toAdd = append(toAdd, newItem)
		}
	}
	for _, oldItem := range old {
		if _, found := keepItems[oldItem]; !found {
			toRemove = append(toRemove, oldItem)
		}
	}

	diff := DiffUInt64{
		ToAdd:    toAdd,
		NoChange: noChange,
		ToRemove: toRemove,
	}
	return diff
}
