package tvmauthadapter

import (
	"context"
	"errors"
	"fmt"

	"a.yandex-team.ru/library/go/yandex/tvm"
	"a.yandex-team.ru/passport/backend/federal_config_api/internal/core/interfaces"
)

type tvmAuthAdapter struct {
	tvm tvm.Client
}

// compile-time проверка, что интерфейс имплементирован корректно
var _ interfaces.AuthAdapter = (*tvmAuthAdapter)(nil)

func NewTVMAuthAdapter(tvm tvm.Client) (*tvmAuthAdapter, error) {
	return &tvmAuthAdapter{tvm}, nil
}

func (a *tvmAuthAdapter) HasRole(ctx context.Context, role string) (bool, error) {
	return a.HasRoles(ctx, []string{role})
}

func (a *tvmAuthAdapter) HasRoles(ctx context.Context, roles []string) (bool, error) {
	st := tvm.ContextServiceTicket(ctx)
	if st == nil {
		return false, errors.New("no service ticket in context")
	}
	r, err := a.tvm.GetRoles(ctx)
	if err != nil {
		return false, err
	}
	var missingRoles []string
	for _, role := range roles {
		if !r.GetRolesForService(st).HasRole(role) {
			missingRoles = append(missingRoles, role)
		}
	}
	if len(missingRoles) > 0 {
		return false, fmt.Errorf("missing roles: %s", missingRoles)
	} else {
		return true, nil
	}
}
