package interfaces

import (
	"context"

	"a.yandex-team.ru/passport/backend/federal_config_api/internal/core/models"
)

type FederalConfigAdapter interface {
	Create(ctx context.Context, config models.FederationConfig) (uint64, error)
	GetByConfigID(ctx context.Context, namespace string, configID uint64) (models.FederationConfig, error)
	GetByEntityID(ctx context.Context, namespace string, entityID string) (models.FederationConfig, error)
	GetByDomainID(ctx context.Context, namespace string, domainID uint64) (models.FederationConfig, error)
	List(ctx context.Context, namespace string, startConfigID uint64, limit uint64) ([]models.FederationConfig, error)
	Update(ctx context.Context, namespace string, entityID *string, domainIDs *[]uint64, configID uint64, configBody models.ConfigBody) error
	Delete(ctx context.Context, namespace string, configID uint64) error
}

type PDDAdapter interface {
	Exists(ctx context.Context, domainID []uint64) (bool, error)
}

type AuthAdapter interface {
	HasRole(ctx context.Context, role string) (bool, error)
	HasRoles(ctx context.Context, roles []string) (bool, error)
}
