package models

type FederationConfig struct {
	ConfigID  uint64   `json:"config_id"`
	EntityID  string   `json:"entity_id"`
	DomainIDs []uint64 `json:"domain_ids"`
	Namespace string   `json:"namespace"`
	ConfigBody
}

type ConfigBody struct {
	SAMLConfig  SAMLConfig  `json:"saml_config"`
	OAuthConfig OAuthConfig `json:"oauth_config"`
	Enabled     bool        `json:"enabled"`
}

func (fc *FederationConfig) InjectBody(configBody ConfigBody) {
	fc.ConfigBody.SAMLConfig = configBody.SAMLConfig
	fc.ConfigBody.OAuthConfig = configBody.OAuthConfig
	fc.ConfigBody.Enabled = configBody.Enabled
}
