package models

type SAMLService struct {
	URL     string `json:"url"`
	Binding string `json:"binding"`
}

type X509Cert struct {
	New string `json:"new"`
	Old string `json:"old"`
}

type SAMLConfig struct {
	SingleSignOnService    SAMLService `json:"single_sign_on_service"`
	SingleLogoutService    SAMLService `json:"single_logout_service"`
	X509Cert               X509Cert    `json:"x509_cert"`
	LowercaseUrlencoding   bool        `json:"lowercase_urlencoding"`
	DisableJitProvisioning bool        `json:"disable_jit_provisioning"`
}
