package federalcfgapi

import (
	"encoding/json"
	"net/http"

	"github.com/labstack/echo/v4"

	"a.yandex-team.ru/passport/backend/federal_config_api/internal/core/models"
)

func (t *FederalConfigAPI) HandleAddConfig() echo.HandlerFunc {
	return t.AssertRoleOnNamespace(NamespaceRoleOpWrite, func(c echo.Context) error {
		var ptrEntityID *string
		var entityID string
		var domainIDs []uint64
		var namespace string

		if c.Request().Form.Has("entity_id") {
			entityID = c.Request().Form.Get("entity_id")
			ptrEntityID = &entityID
		}
		if c.Request().Form.Has("domain_id") {
			for _, domainID := range c.Request().Form["domain_id"] {
				domainIDs = append(domainIDs, strToInt(domainID))
			}
		}

		namespace = c.Request().Form.Get("namespace")

		var configBody models.ConfigBody
		configBody.Enabled = true
		err := json.NewDecoder(c.Request().Body).Decode(&configBody)
		if err != nil {
			return c.String(http.StatusInternalServerError, err.Error())
		}

		var config models.FederationConfig
		config.InjectBody(configBody)
		if ptrEntityID != nil {
			config.EntityID = *ptrEntityID
		}
		config.DomainIDs = domainIDs
		config.Namespace = namespace

		config, err = t.configController.Create(c.Request().Context(), config)
		if err != nil {
			return t.GenericHandleError(c, err)
		}
		return c.JSON(http.StatusCreated, config)
	})
}
