package federalcfgapi

import (
	"fmt"
	"net/http"
	"strconv"

	"github.com/labstack/echo/v4"
)

func (t *FederalConfigAPI) HandleDeleteConfig() echo.HandlerFunc {
	return t.AssertRoleOnNamespace(NamespaceRoleOpWrite, func(c echo.Context) error {
		configID, err := strconv.ParseUint(c.Param("config_id"), 0, 64)
		if err != nil {
			return c.String(http.StatusBadRequest, fmt.Sprintf("error parsing config_id: %s", err.Error()))
		}

		err = t.configController.Delete(
			c.Request().Context(),
			c.Request().Form.Get("namespace"),
			configID,
		)
		if err != nil {
			return t.GenericHandleError(c, err)
		}
		return c.JSON(http.StatusOK, "")
	})
}
