package federalcfgapi

import (
	"encoding/json"
	"fmt"
	"net/http"
	"strconv"

	"github.com/labstack/echo/v4"

	"a.yandex-team.ru/passport/backend/federal_config_api/internal/core/models"
)

func (t *FederalConfigAPI) HandleEditConfig() echo.HandlerFunc {
	return t.AssertRoleOnNamespace(NamespaceRoleOpWrite, func(c echo.Context) error {
		var (
			ptrEntityID  *string
			entityID     string
			ptrDomainIDs *[]uint64
			domainIDs    []uint64
			configID     uint64
			namespace    string
			config       models.FederationConfig
		)

		if c.Request().Form.Has("entity_id") {
			entityID = c.Request().Form.Get("entity_id")
			ptrEntityID = &entityID
			config.EntityID = entityID
		}
		if c.Request().Form.Has("domain_id") {
			for _, domainID := range c.Request().Form["domain_id"] {
				domainIDs = append(domainIDs, strToInt(domainID))
			}
			ptrDomainIDs = &domainIDs
			config.DomainIDs = domainIDs
		}
		configID, err := strconv.ParseUint(c.Param("config_id"), 0, 64)
		if err != nil {
			return c.String(http.StatusBadRequest, fmt.Sprintf("error parsing config_id: %s", err.Error()))
		}

		namespace = c.Request().Form.Get("namespace")

		var configBody models.ConfigBody
		configBody.Enabled = true
		err = json.NewDecoder(c.Request().Body).Decode(&configBody)
		if err != nil {
			return c.String(http.StatusInternalServerError, err.Error())
		}
		config.InjectBody(configBody)
		config.Namespace = namespace
		config.ConfigID = configID

		err = t.configController.Update(
			c.Request().Context(),
			namespace,
			ptrEntityID,
			ptrDomainIDs,
			configID,
			config.ConfigBody,
		)
		if err != nil {
			return t.GenericHandleError(c, err)
		}
		return c.JSON(http.StatusOK, config)
	})
}
