package federalcfgapi

import (
	"net/http"
	"net/url"
	"strconv"

	"github.com/labstack/echo/v4"

	"a.yandex-team.ru/passport/backend/federal_config_api/internal/core/models"
)

func (t *FederalConfigAPI) HandleGetByConfigIDConfig() echo.HandlerFunc {
	return t.AssertRoleOnNamespace(NamespaceRoleOpRead, func(c echo.Context) error {
		var (
			config    models.FederationConfig
			err       error
			configID  uint64
			namespace string
		)

		ctx := c.Request().Context()

		configID, err = strconv.ParseUint(c.Param("config_id"), 0, 64)
		if err != nil {
			return t.GenericHandleError(c, err)
		}

		namespace = c.Request().Form.Get("namespace")
		config, err = t.configController.GetByConfigID(ctx, namespace, configID)
		if err != nil {
			return t.GenericHandleError(c, err)
		}

		return c.JSON(http.StatusOK, config)
	})
}

func (t *FederalConfigAPI) HandleGetByDomainIDConfig() echo.HandlerFunc {
	return t.AssertRoleOnNamespace(NamespaceRoleOpRead, func(c echo.Context) error {
		var (
			config    models.FederationConfig
			err       error
			domainID  uint64
			namespace string
		)

		ctx := c.Request().Context()

		domainID, err = strconv.ParseUint(c.Param("domain_id"), 0, 64)
		if err != nil {
			return t.GenericHandleError(c, err)
		}

		namespace = c.Request().Form.Get("namespace")
		config, err = t.configController.GetByDomainID(ctx, namespace, domainID)
		if err != nil {
			return t.GenericHandleError(c, err)
		}

		return c.JSON(http.StatusOK, config)
	})
}

func (t *FederalConfigAPI) HandleGetByEntityIDConfig() echo.HandlerFunc {
	return t.AssertRoleOnNamespace(NamespaceRoleOpRead, func(c echo.Context) error {
		var (
			config    models.FederationConfig
			err       error
			entityID  string
			namespace string
		)

		ctx := c.Request().Context()
		entityID, err = url.PathUnescape(c.Param("entity_id"))
		if err != nil {
			return t.GenericHandleError(c, err)
		}
		namespace = c.Request().Form.Get("namespace")
		config, err = t.configController.GetByEntityID(ctx, namespace, entityID)
		if err != nil {
			return t.GenericHandleError(c, err)
		}

		return c.JSON(http.StatusOK, config)
	})
}
