package federalcfgapi

import (
	"net/http"

	"github.com/labstack/echo/v4"

	"a.yandex-team.ru/passport/backend/federal_config_api/internal/core/models"
)

type ResponseList struct {
	Configs []models.FederationConfig `json:"configs"`
}

func (t *FederalConfigAPI) HandleListConfig() echo.HandlerFunc {
	return t.AssertRoleOnNamespace(NamespaceRoleOpRead, func(c echo.Context) error {
		var (
			namespace     string
			startConfigID uint64
			limit         uint64
			configs       []models.FederationConfig
			responseList  ResponseList
		)

		ctx := c.Request().Context()

		queryParams := c.Request().URL.Query()

		if queryParams.Has("start_config_id") {
			startConfigID = strToInt(queryParams.Get("start_config_id"))
		} else {
			startConfigID = 0
		}
		if queryParams.Has("limit") {
			limit = strToInt(queryParams.Get("limit"))
		} else {
			limit = 100
		}

		namespace = queryParams.Get("namespace")
		configs, err := t.configController.List(ctx, namespace, startConfigID, limit)
		responseList.Configs = configs

		if err != nil {
			return t.GenericHandleError(c, err)
		}
		return c.JSON(http.StatusOK, responseList)
	})
}
