package federalcfgapi

import (
	"errors"
	"fmt"
	"os"
	"strconv"
)

type DatabaseConfig struct {
	Username     string
	Password     string
	DatabaseName string
	Host         string
	Port         int
}

func getOsVar(key string) string {
	value, exists := os.LookupEnv(key)
	if !exists || len(value) == 0 {
		panic(fmt.Errorf("env var %s must be set", key))
	}
	return value

}

func (dc *DatabaseConfig) ParseFromEnv() {
	dc.Username = getOsVar("DB_USERNAME")
	dc.Password = getOsVar("DB_PASSWORD")
}

func (dc *DatabaseConfig) validateStruct() {
	if len(dc.Username) == 0 {
		panic(errors.New("database username is not set"))
	}
	if len(dc.Password) == 0 {
		panic(errors.New("database password is not set"))
	}
	if len(dc.DatabaseName) == 0 {
		panic(errors.New("database name is not set"))
	}
	if len(dc.Host) == 0 {
		panic(errors.New("database host is not set"))
	}
	if dc.Port == 0 {
		panic(errors.New("database port is not set"))
	}
}

func (dc *DatabaseConfig) ToConnString() string {
	dc.validateStruct()
	return fmt.Sprintf(
		"user=%s password=%s dbname=%s host=%s port=%s",
		dc.Username,
		dc.Password,
		dc.DatabaseName,
		dc.Host,
		strconv.Itoa(dc.Port),
	)
}
