package tracer

import (
	hasql "golang.yandex/hasql"

	"a.yandex-team.ru/library/go/core/log"
)

func NewTracer(logger log.Logger) hasql.Tracer {
	return hasql.Tracer{
		UpdateNodes: func() {
			logger.Infof("started updating nodes...")
		},
		UpdatedNodes: func(nodes hasql.AliveNodes) {
			logger.Infof("finished updating nodes: %+v", nodes)
		},
		NodeDead: func(node hasql.Node, err error) {
			logger.Errorf("node %q is dead: %s", node, err.Error())
		},
		NodeAlive: func(node hasql.Node) {
			logger.Infof("node %q is alive", node)
		},
		NotifiedWaiters: func() {
			logger.Info("notified all waiters")
		},
	}
}
