create table configs (
    config_id serial primary key,
    attributes jsonb not null
);

create table entity_id_to_config_id (
    entity_id text primary key,
    config_id bigint not null references configs on delete cascade on update cascade,
    constraint uq unique (entity_id, config_id),
    foreign key (config_id) references configs (config_id)
);

create index config_id_entity_idx on entity_id_to_config_id (config_id);

create table domain_id_to_config_id (
    domain_id bigint not null,
    config_id bigint not null references configs on delete cascade on update cascade,
    primary key (domain_id, config_id),
    foreign key (config_id) references configs (config_id)
);

create index config_id_domain_idx on domain_id_to_config_id (config_id);

create table namespace_to_config_id (
    namespace text not null,
    config_id bigint not null references configs on delete cascade on update cascade,
    primary key (namespace, config_id),
    foreign key (config_id) references configs (config_id)
);
