server {
    listen [::]:80;
    server_name ~^user\.grantushka\.passportdev-python\.yandex-team\.ru;

    root /usr/lib/yandex/passport-grants-configurator/passport_grants_configurator;

    location /dostup/ {

        proxy_pass http://127.0.0.1:#port#;
        proxy_set_header Host $host;
        proxy_set_header X-Real-IP $remote_addr;
        proxy_set_header X-Forwarded-For $proxy_add_x_forwarded_for;
    }

    ssl                         on;
    ssl_certificate             /etc/nginx/certs/grantushka.crt;
    ssl_certificate_key         /etc/nginx/certs/grantushka.key;
    ssl_session_cache           shared:SSL:32m;
    ssl_session_timeout         5m;
    ssl_protocols               TLSv1 TLSv1.1 TLSv1.2;
    ssl_ciphers                 kEECDH+AESGCM+AES128:kEECDH+AES128:kRSA+AESGCM+AES128:kRSA+AES128:DES-CBC3-SHA:!RC4:!aNULL:!eNULL:!MD5:!EXPORT:!LOW:!SEED:!CAMELLIA:!IDEA:!PSK:!SRP:!SSLv2;
    ssl_prefer_server_ciphers   on;
}
