# -*- coding: utf-8 -*-
from fabric.api import (
    env,
    local,
    task,
)
from passport_ci.buildfarm import *
from passport_ci.development import *
from robe import venv

env.robe.projects = {
    'passport-grants-configurator': {
        'path': '.',
        'use_global_site_packages': True,
    },
}

env.robe.dev_dir = 'env'
env.robe.release_dir = 'production_env'
env.robe.venv.requirements_file = 'requirements/base.txt'
env.robe.venv.requirements_dev_file = 'requirements/development.txt'

env.robe.venv.in_parallel = True
env.robe.venv.accelerator = 'wheel'
env.robe.venv.quiet_install = False
env.robe.venv.pip_version = '9.0.3'
env.robe.venv.wheel_version = '0.30.0'

env.passport.pypi_release_dirs = ['.']
env.passport.git = [
    {
        'dir': '.',
        'owner': 'passport',
        'repository': 'passport-grants-configurator',
    },
]


@task()
def test():
    with venv.activate():
        local('python manage.py test --settings=passport_grants_configurator.settings.buildfarm --exclude="no_buildfarm"')


@task()
def run():
    with venv.activate():
        local('./manage.py runserver 9090')


@task()
def build():
    local('arc checkout trunk')
    local('arc pull')
    local('debuild --preserve-env --set-envvar=PIP_USER=${USER}')
    local('debrelease --to=passport-precise')
