#!/usr/bin/env python
# -*- coding: utf-8 -*-
# isort:skip_file
import os
import sys
import warnings
import yenv

# add usr/lib/yandex/yandex-project-name/ to the sys.path
try:
    activate_this = os.path.join(os.path.dirname(os.path.realpath(__file__)), 'activate_this.py')
    execfile(activate_this, dict(__file__=activate_this))
    del activate_this
except IOError:
    pass

sys.path.insert(0, os.path.dirname(os.path.dirname(os.path.dirname(os.path.dirname(os.path.abspath(__file__))))))

_current_user = os.environ.get('USER', os.environ.get('LOGNAME', 'root'))

from django.core.management import execute_from_command_line


if __name__ == '__main__':
    if yenv.type != 'development':
        warnings.filterwarnings('ignore', category=FutureWarning)
        warnings.filterwarnings('ignore', category=DeprecationWarning)

    module = yenv.type
    if yenv.type == 'development' and _current_user not in ['root', 'www-data']:
        module = 'user_%s' % _current_user
    os.environ.setdefault('DJANGO_SETTINGS_MODULE', 'passport_grants_configurator.settings.' + module)

    execute_from_command_line(sys.argv)
