# -*- coding: utf-8 -*
from __future__ import unicode_literals

from django.contrib import admin
from django import forms
from django.contrib.admin.widgets import FilteredSelectMultiple
from guardian.admin import GuardedModelAdmin

from .forms import (
    ActionForm,
    ConsumerForm,
    GrantForm,
)
from .models import (
    Action,
    Client,
    Consumer,
    Environment,
    Grant,
    Macros,
    Namespace,
    NamespaceEnvironments,
    Network,
    Issue,
)


class EnvironmentAdmin(admin.ModelAdmin):
    list_display = ('type', 'name', 'description')


class NamespaceEnvironmentsAdmin(GuardedModelAdmin):
    """Интеграция с django_guardian для выдачи прав на отдельные окружения отдельных проектов"""


class MacrosAdminForm(forms.ModelForm):
    action = forms.ModelMultipleChoiceField(
        queryset=Action.objects.select_related().all(),
        label='Грант',
        widget=FilteredSelectMultiple('actions', False)
    )

    class Meta(object):
        model = Macros

    def __init__(self, *args, **kwargs):
        super(MacrosAdminForm, self).__init__(*args, **kwargs)
        namespace = self.instance.namespace
        self.fields['action'].queryset = Action.objects.select_related().filter(grant__namespace=namespace)


class ConsumerAdmin(admin.ModelAdmin):
    list_filter = ('namespace',)
    list_display = ('name', 'namespace', 'description')
    search_fields = ('name', 'description')
    form = ConsumerForm


class MacrosAdmin(admin.ModelAdmin):
    form = MacrosAdminForm


class ActionAdmin(admin.ModelAdmin):
    list_filter = ('grant__namespace', 'dangerous', 'grant')
    search_fields = ('name', 'grant__name')
    form = ActionForm


class GrantAdmin(admin.ModelAdmin):
    list_filter = ('namespace',)
    search_fields = ('name',)
    form = GrantForm


class NetworkAdmin(admin.ModelAdmin):
    list_filter = ('type',)
    search_fields = ('string',)


class IssueAdmin(admin.ModelAdmin):
    list_display = ('status', 'creation_date', 'namespace', 'approving_person')
    list_filter = ('approving_person', 'namespace', 'status', 'type', 'environments')
    search_fields = ('consumer__name', 'consumer_name', 'consumer_name_new')
    date_hierarchy = 'creation_date'


admin.site.register(Action, ActionAdmin)
admin.site.register(Macros, MacrosAdmin)
admin.site.register(Grant, GrantAdmin)

admin.site.register(Network, NetworkAdmin)

admin.site.register(Consumer, ConsumerAdmin)
admin.site.register(Environment, EnvironmentAdmin)
admin.site.register(Namespace)
admin.site.register(Client)
# Возможность редактировать существующие разрешения на проекты и окружения
admin.site.register(NamespaceEnvironments, NamespaceEnvironmentsAdmin)

admin.site.register(Issue, IssueAdmin)
