# -*- coding: utf-8 -*-

from .utils import grouped


def serialize_grants(actions, items=('name', 'description', 'id', 'dangerous')):
    action_tree = []
    group_key = lambda a: a.grant.name
    getter = lambda action: {i: getattr(action, i) for i in items}
    for grant_name, actions_ in grouped(actions, key=group_key):
        action_tree.append({
            'name': grant_name,
            'actions': [getter(action) for action in actions_],
        })
    return action_tree


def deserialize_grants(actions):
    """Берет итеририруемый объект с action и строит из него понятное для вьюхи JSON-like дерево"""
    meta_grants = {}
    for action in actions:
        meta_grants.setdefault(action.grant.name, {})[action.name] = action.description
    return meta_grants


def deserialize_macroses(macroses):
    """Берет итеририруемый объект с группами грантов и строит из него понятное для вьюхи JSON-like дерево"""
    meta_macroses = {}
    for macros in macroses:
        actions = macros.action.select_related()
        meta_macros, _ = meta_macroses[macros.name] = [deserialize_grants(actions), macros.description]
    return meta_macroses
