# -*- coding: utf-8 -*-

from django.conf import settings as django_settings
from django.contrib.auth.models import AnonymousUser

from .permissions import UserPermissions, namespace_selection

SETTINGS_TO_TEMPLATES = (
    'FEEDBACK_EMAIL_ADDRESS',
)


def settings(request):
    """Предоставим в шаблонах доступ к некоторым настройкам"""
    settings_context = {}
    for setting_name in SETTINGS_TO_TEMPLATES:
        setting_value = getattr(django_settings, setting_name)
        settings_context[setting_name] = setting_value

    return {
        'settings': settings_context,
    }


def namespaces(request):
    """Добавим в контекст шаблонов информацию о текущем проекте и всех окружениях"""
    context_extras = namespace_selection(request)
    if not isinstance(request.user, AnonymousUser):
        context_extras.update(
            user_namespace_environments=UserPermissions(request.user).queryset,
        )
    return context_extras
