# -*- coding: utf-8 -*-


class BaseError(Exception):
    """Базовая ошибка Грантушки"""


class ProcessError(BaseError):
    """Ошибки при вызовах внешнего приложения"""


class SubprocessTimedOut(ProcessError):
    """Выполнение подпроцесса превысило допустимое время"""


class NoDataChanges(BaseError):
    """Данные должны измениться но не изменились"""


# Класс инициализируется списком строк - текстами ошибок
class ExportError(BaseError):
    """Ошибки во время экспорта данных"""


# TODO: Эта ошибка слишком общая и используется почти везде
# Надо обрабатывать специфичные исключения в разных случаях
class NetworkResolveError(BaseError):
    """Не удается преобразовать один тип сетевого объекта в другой"""


# TODO: Вынести выше по иерархии ошибок
class APIRequestFailedError(NetworkResolveError):
    """Не удалось выполнить http-запрос во внешнее АПИ"""


class UnknownNetworkTypeError(NetworkResolveError):
    """Не удалось определить тип сетевого объекта - адрес, хост, сеть или макрос"""


class HostResolvingFailed(NetworkResolveError):
    """При определении адресов узла ничего не нашли"""


class NoDataError(BaseError):
    """Не удалось получить данные от стороннего компонента - пустой ответ АПИ"""


class ImproperlyConfigured(BaseError):
    """Ошибка в настройках приложения"""


class NoDiffError(ExportError):
    """Нет изменений в структуре грантов"""


class NotFoundError(APIRequestFailedError):
    """Ресурс не найден"""
