# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django.conf import settings
from django.contrib.auth.models import User, Group, Permission
from django.contrib.contenttypes.models import ContentType
from django_docopt_command import DocOptCommand
from guardian.models import GroupObjectPermission

from passport_grants_configurator.apps.core.models import *

META_ENVIRONMENTS = [
    {'name': 'localhost', 'type': 'production', 'description': 'localhost production', 'priority': 1},
    {'name': 'localhost', 'type': 'testing', 'description': 'localhost testing', 'priority': 2},
    {'name': 'localhost', 'type': 'development', 'description': 'localhost development', 'priority': 3},
    {'name': 'intranet', 'type': 'production', 'description': 'intranet production', 'priority': 4},
    {'name': 'intranet', 'type': 'testing', 'description': 'intranet testing', 'priority': 5},
    {'name': 'intranet', 'type': 'development', 'description': 'intranet development', 'priority': 6},
    {'name': 'stress', 'type': 'stress', 'description': 'stress stress', 'priority': 7},
    {'name': 'other', 'type': 'production', 'description': 'other production', 'priority': 8},
    {'name': 'localhost', 'type': 'rc', 'description': 'rc', 'priority': 9},
]


class Command(DocOptCommand):
    docs = '''Usage: actualize_permissions'''

    def handle_docopt(self, arguments):

        admins = settings.PASSPORT_TEAM_ADMIN
        namespace_staff = {
            'passport': settings.PASSPORT_TEAM_DEV,
            'social api': settings.SOCIAL_API_TEAM,
            'social proxy': settings.SOCIAL_API_TEAM,
            'yasms': settings.YASMS_TEAM,
        }
        grant_editors = settings.PASSPORT_TEAM_DEV

        # Создаем группы с правами на окружения
        environment_groups = {}
        environment_ctid = ContentType.objects.get(model='environment', app_label='core').id
        for me in META_ENVIRONMENTS:
            Group.objects.filter(name=me['description']).delete()
            new_group, _ = Group.objects.get_or_create(name='Окружение ' + me['description'])

            try:
                new_environment = Environment.objects.get(name=me['name'], type=me['type'])
                new_environment.description = me['description']
                new_environment.priority = me['priority']
                new_environment.save()
            except Environment.DoesNotExist:
                new_environment = Environment.objects.create(**me)

            permission, _ = Permission.objects.get_or_create(content_type_id=environment_ctid, codename="review_environment_issue")
            permission.name = 'Права администратора для окружения'
            permission.save()
            permission_id = permission.id

            GroupObjectPermission.objects.get_or_create(permission_id=permission_id, content_type_id=environment_ctid,
                                                        group_id=new_group.id, object_pk=new_environment.pk)
            environment_groups[me['name'], me['type']] = new_group

        # Создаем группы с правами на проекты
        namespace_groups = {}
        namespace_ctid = ContentType.objects.get(model='namespace', app_label='core').id
        for namespace_name, environments in settings.NAMESPACE_ENVIRONMENTS.items():
            namespace, _ = Namespace.objects.get_or_create(name=namespace_name)
            for name, type in environments:
                environment = Environment.objects.get(name=name, type=type)
                # https://code.djangoproject.com/ticket/21763
                name_env, is_created = NamespaceEnvironments.objects.get_or_create(
                    environment=environment,
                    namespace=namespace,
                )
                if is_created:
                    name_env.save()

            Group.objects.filter(name=namespace_name).delete()
            new_group, _ = Group.objects.get_or_create(name='Проект ' + namespace_name)

            permission, _ = Permission.objects.get_or_create(content_type_id=namespace_ctid,
                                                             codename='review_namespace_issue')
            permission.name = 'Права администратора для проетов'
            permission.save()
            GroupObjectPermission.objects.get_or_create(permission_id=permission.id, content_type_id=namespace_ctid,
                                                        group_id=new_group.id, object_pk=namespace.pk)
            namespace_groups[namespace_name] = new_group

        # Создаем группу с правами на редактирование грантов
        grant_cts = ContentType.objects.filter(model__in=('action', 'grant', 'macros'), app_label='core')
        grant_group, _ = Group.objects.get_or_create(name='Изменение перечня грантов')
        grant_permissions = Permission.objects.filter(content_type__in=grant_cts)
        for permission in grant_permissions:
            grant_group.permissions.add(permission)

        # Раздаем пользователям группы
        for admin in admins:
            new_user, _ = User.objects.get_or_create(username=admin)
            new_user.is_staff = True
            new_user.is_superuser = True
            new_user.save()

            for group in environment_groups.values() + namespace_groups.values():
                new_user.groups.add(group)

        dev_groups = [group for (name, type), group in environment_groups.iteritems() if type in ['stress', 'development']]
        for namespace, staff in namespace_staff.iteritems():
            for user in staff:
                new_user, _ = User.objects.get_or_create(username=user)
                new_user.save()

                for group in dev_groups:
                    new_user.groups.add(group)

                new_user.groups.add(namespace_groups[namespace])

        for user in grant_editors:
            new_user, _ = User.objects.get_or_create(username=user)
            new_user.is_staff = True
            new_user.save()
            new_user.groups.add(grant_group)
