# -*- coding: utf-8 -*-

from optparse import make_option
from django.core.management.base import BaseCommand

from passport_grants_configurator.apps.core.models import (
    Action,
    Grant,
    Namespace,
    NamespaceEnvironments,
)


class Command(BaseCommand):
    help = u'Заполняет грантами namespace Blackbox By Client'
    option_list = BaseCommand.option_list + (
        make_option(
            '--undo',
            action='store_true',
            dest='undo',
            default=False,
            help=u'Удалить гранты namespace Blackbox By Client',
        ),
    )

    def handle(self, *args, **options):
        bb_client_namespace, is_created = Namespace.objects.get_or_create(name='blackbox_by_client')

        if is_created:
            print 'Created namespace Blackbox By Client'

        if options['undo']:
            Namespace.objects.get(id=bb_client_namespace.id).delete()
            print 'Deleted namespace Blackbox By Client'
            return

        blackbox_envs = Namespace.objects.get(name='blackbox').environments.all()

        for bb_env in blackbox_envs:
            NamespaceEnvironments.objects.get_or_create(
                environment=bb_env,
                namespace=bb_client_namespace,
            )

        methods = ['login_attrs', 'user_info_attrs', 'oauth_attrs', 'session_id_attrs']
        extended_attrs = ['allowed_attributes', 'allowed_phone_attributes']
        dbfields = [
            'subscription.login.8',
            'accounts.ena.uid',
            'accounts.glogout.uid',
            'subscription.login.89',
            'userinfo.display_name.uid',
            'accounts.karma.uid',
            'userinfo_safe.cryptpasswd.uid',
            'passport_quality.quality.uid',
            'passport_quality.version.uid',
            'subscription.login_rule.8',
            'userinfo_safe.hintq.uid',
            'userinfo_safe.hinta.uid',
            'userphones.number.uid',
            'userinfo.nickname.uid',
        ]

        bb_namespace = Namespace.objects.get(name='blackbox')

        bb_grants = Grant.objects.filter(namespace=bb_namespace)\
            .exclude(name__contains='dbfield.').exclude(name__in=extended_attrs)

        grants_counter = new_grants_counter = 0
        actions_counter = new_actions_counter = 0

        for bb_grant in bb_grants:
            new_grant, is_created = Grant.objects.get_or_create(
                name=bb_grant.name,
                namespace=bb_client_namespace,
                description=bb_grant.description,
            )
            grants_counter += 1
            if is_created:
                new_grants_counter += 1

            bb_grant_actions = Action.objects.filter(grant=bb_grant)
            for bb_action in bb_grant_actions:
                _, is_created = Action.objects.get_or_create(
                    name=bb_action.name,
                    grant=new_grant,
                    description=bb_action.description,
                    dangerous=bb_action.dangerous,
                )
                actions_counter += 1
                if is_created:
                    new_actions_counter += 1

        # Сохраняем attributes, phone_attributes и dbfields в операции указанных методов ЧЯ
        attr_grant = Grant.objects.filter(name='allowed_attributes')
        attr_actions = Action.objects.filter(grant=attr_grant)

        phone_attr_grant = Grant.objects.filter(name='allowed_phone_attributes')
        phone_attr_actions = Action.objects.filter(grant=phone_attr_grant)

        for method in methods:
            method_grant, is_created = Grant.objects.get_or_create(
                name=method,
                namespace=bb_client_namespace,
                description='Blackbox method',
            )
            grants_counter += 1
            if is_created:
                new_grants_counter += 1
            for attr in attr_actions:
                _, is_created = Action.objects.get_or_create(
                    name='attr:%s' % attr.name,
                    grant=method_grant,
                    description=attr.description,
                    dangerous=attr.dangerous,
                )
                actions_counter += 1
                if is_created:
                    new_actions_counter += 1

            for phone_attr in phone_attr_actions:
                _, is_created = Action.objects.get_or_create(
                    name='phone_attr:%s' % phone_attr.name,
                    grant=method_grant,
                    description=phone_attr.description,
                    dangerous=phone_attr.dangerous,
                )
                actions_counter += 1
                if is_created:
                    new_actions_counter += 1

            for db_field in dbfields:
                _, is_created = Action.objects.get_or_create(
                    name='dbfield:%s' % db_field,
                    grant=method_grant,
                    description='',
                    dangerous=False,
                )
                actions_counter += 1
                if is_created:
                    new_actions_counter += 1

        if grants_counter == new_grants_counter and actions_counter == new_actions_counter:
            print 'Successfully added %d Grants; %d Actions' % (grants_counter, actions_counter)
        else:
            print 'Created %d/%d Grants; %d/%d Actions' % (new_grants_counter, grants_counter,
                                                           actions_counter, new_actions_counter)
