# -*- coding: utf-8 -*-
from django.core.management.base import BaseCommand

from passport_grants_configurator.apps.core.models import (
    Consumer,
    Namespace,
)


class Command(BaseCommand):
    help = u'Заменяет пробелы в именах потребителей проекта Blackbox на "_"'

    def handle(self, *args, **options):
        bb_namespace = Namespace.objects.get(name='blackbox')
        consumers = Consumer.objects.filter(namespace=bb_namespace)

        for consumer in consumers:
            consumer.name = consumer.name.replace(' ', '_')
            consumer.save()

        print('Done: %d consumer names changed' % len(consumers))
