# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django_docopt_command import DocOptCommand

from passport_grants_configurator.apps.core.models import Action, Namespace

ACTION_DESCRIPTIONS = {
    'allow_login': 'разрешить вызов метода login',
    'allow_login_by_uid': 'разрешить вызов метода login с идентификацией по uid вместо логина, требует наличия гранта "allow_login"',
    'allow_parse_cookie': 'разрешить вызов метода sessionid (проверка сессионной куки)',
    'allow_oauth': 'разрешить вызов метода oauth',
    'allow_comp_cookie': 'разрешить проверку компрессированных кук в методах sessionid, createsession и litesession',
    'allow_parse_info': 'разрешить вызов метода sessioninfo и syninfo',
    'allow_logout_info': 'разрешить вызов метода logoutsessioninfo',
    'allow_list_del_cookies': 'разрешить вызов метода listdelcookies',
    'allow_lite_session': 'разрешить вызов метода litesession',
    'allow_user_info': 'разрешить вызов метода userinfo',
    'allow_smtplogin': 'не используется',
    'allow_geo': 'разрешить вызов метода geo',
    'allow_mail_host': 'разрешить вызов метода mailhost',
    'allow_narod_host': 'разрешить вызов метода narodhost',
    'allow_pwd_quality': 'разрешить вызов метода pwdquality',
    'allow_check_ip': 'разрешить вызов метода checkip',
    'allow_clear_badauth': 'разрешить вызов метода clearbadauth',
    'allow_ignore_signature': 'разрешить игнорировать подпись в куке sessionid (ТОЛЬКО для тестовых целей!)',
    'allow_sign': 'разрешить вызов метода sign',
    'allow_check_signature': 'разрешить вызов метода checksignature',
    'allow_login_occupation': 'разрешить вызов метода loginoccupation',
    'allow_pwd_history': 'разрешить вызов метода pwdhistory',
    'allow_transform_session': 'разрешить вызов метода createsession по существующей sessionid',
    'allow_create_session': 'разрешить вызов метода createsession по uid (создание сессии для произвольного uid-а)',
    'allow_user_messages': 'разрешить вызов метода usermessages',
    'allow_hosted_domains': 'разрешить вызов метода hosted_domains',
    'allow_get_hosts': 'разрешить вызов метода get_hosts',
    'allow_find_pdd_accounts': 'разрешить вызов метода find_pdd_accounts',
    'allow_get_keyspaces': 'разрешить вызов метода get_keyspaces',
}


class Command(DocOptCommand):
    docs = '''Usage: blackbox_describe_grants'''

    def handle_docopt(self, arguments):
        blackbox, __ = Namespace.objects.get_or_create(name='blackbox')

        for action in Action.objects.select_related().filter(grant__namespace=blackbox, grant__name__in=ACTION_DESCRIPTIONS):
            action.description = ACTION_DESCRIPTIONS[action.grant.name]
            action.save()
