# -*- coding: utf-8 -*-
from __future__ import unicode_literals
import os
import shutil

from sh import svn
from django.core.management import call_command
from django_docopt_command import DocOptCommand

from passport_grants_configurator.apps.core.models import (
    Action,
    Consumer,
    Environment,
    Grant,
    Namespace,
    ActiveAction,
    ActiveMacros,
    ActiveNetwork,
)

FILENAMES = {
    ('localhost', 'production', 1): 'production/grants.conf',
    ('localhost', 'development', 3): 'production/dev/grants-dev.conf',
    ('localhost', 'testing', 2): 'production/dev/grants-test.conf',
    ('stress', 'stress', 7): 'production/grants-stress.conf',
    ('other', 'production', 8): 'production/grants-mimino.conf',
    ('intranet', 'production', 4): 'production/grants-yateam.conf',
}


class Command(DocOptCommand):
    docs = '''Usage: blackbox_load_grants_from_svn --real_run'''

    def handle_docopt(self, arguments):
        svn_password = os.environ.get('BB_SVN_PASSWD')
        if not svn_password:
            raise Exception('Couldnt find BB_SVN_PASSWD environment variable')

        blackbox, _ = Namespace.objects.get_or_create(name='blackbox')

        ActiveAction.objects.filter(consumer__namespace=blackbox).delete()
        ActiveMacros.objects.filter(consumer__namespace=blackbox).delete()
        ActiveNetwork.objects.filter(consumer__namespace=blackbox).delete()
        Consumer.objects.filter(namespace=blackbox).delete()
        Grant.objects.filter(namespace=blackbox).delete()
        Action.objects.filter(grant__namespace=blackbox).delete()

        os.chdir('/tmp')
        print('Downloading consumer grants')
        if os.path.exists('/tmp/production'):
            shutil.rmtree('/tmp/production')

        svn_addr = 'https://svn.yandex.ru/mod_passport_md/branches/fcgi_passport_md/deploy/fastcgi/production'
        print svn.co(
            svn_addr,
            '/tmp/production',
            username='bb',
            password=svn_password,
            no_auth_cache=True,
            non_interactive=True,
            trust_server_cert=True,
        )

        for (env_name, env_type, env_priority), file_ in FILENAMES.items():
            print 'importing "{}"'.format(file_)
            Environment.objects.get_or_create(name=env_name, type=env_type, priority=env_priority)
            if env_type in ('development', 'testing'):  # Для дев и тестинга имена потребителей не прописаны, надо детектировать
                call_command('blackbox_import_grants', **{'<file>': file_, '<name>': env_name, '<type>': env_type, '--detect': True})
            else:
                call_command('blackbox_import_grants', **{'<file>': file_, '<name>': env_name, '<type>': env_type, '--detect': False})

        shutil.rmtree('/tmp/production')
        print 'Blackbox grants have successfully imported from svn'
