# -*- coding: utf-8 -*-
from django_docopt_command import DocOptCommand

from passport_grants_configurator.apps.core.models import (
    Action,
    Grant,
    Namespace,
)


class Command(DocOptCommand):
    docs = """
        Usage:
            copy_grants (-f | --from) <from> (-t | --to) <to> -s <startswith>...
            copy_grants (-h | --help)

        Options:
            -h --help           Show this screen
        """

    help = u'Копирует гранты одного проекта в другой'

    def handle_docopt(self, arguments):
        from_namespace = Namespace.objects.get(name=arguments['<from>'])
        to_namespace = Namespace.objects.get(name=arguments['<to>'])

        grants = []
        for prefix in arguments['<startswith>']:
            grants.extend(Grant.objects.filter(
                namespace=from_namespace,
                name__startswith=prefix,
            ))

        grants_counter = new_grants_counter = 0
        actions_counter = new_actions_counter = 0

        for grant in grants:
            new_grant, is_created = Grant.objects.get_or_create(
                name=grant.name,
                namespace=to_namespace,
                description=grant.description,
            )
            grants_counter += 1
            if is_created:
                new_grants_counter += 1

            grant_actions = Action.objects.filter(grant=grant)
            for action in grant_actions:
                new_action, is_created = Action.objects.get_or_create(
                    name=action.name,
                    grant=new_grant,
                    description=action.description,
                    dangerous=action.dangerous,
                )
                actions_counter += 1
                if is_created:
                    new_actions_counter += 1

        if grants_counter == new_grants_counter and actions_counter == new_actions_counter:
            print 'Successfully added %d Grants; %d Actions' % (grants_counter, actions_counter)
        else:
            print 'Created %d/%d Grants; %d/%d Actions' % (new_grants_counter, grants_counter,
                                                           actions_counter, new_actions_counter)
