# -*- coding: utf-8 -*-
from django.core.management.base import BaseCommand

from passport_grants_configurator.apps.core.models import (
    Grant,
    Namespace,
)


class Command(BaseCommand):
    help = 'Simplify BB by client project grants list'

    def handle(self, *args, **options):
        # В новом проекте ЧЯ сокращаем количество грантов на те, которые требует
        # каких-нибудь учетных данных пользователя для совершения запроса (login, sessionid, oauth)
        # и те, которым это не нужно (userinfo).
        bb_client_namespace = Namespace.objects.get(name='blackbox_by_client')
        no_cred_grants = Grant.objects.filter(name='user_info_attrs', namespace=bb_client_namespace)
        no_cred_grants.update(name='no_cred')

        login_grants = Grant.objects.filter(name='login_attrs', namespace=bb_client_namespace)
        login_grants.update(name='has_cred')

        has_creds_grants_names = ['oauth_attrs', 'session_id_attrs']
        Grant.objects.filter(name__in=has_creds_grants_names, namespace=bb_client_namespace).delete()
        print('Grants simplified')
