# -*- coding: utf-8 -*-

from django.conf import settings
from django.core.management.base import BaseCommand

from passport_grants_configurator.apps.core.caching import redis_connection


class Command(BaseCommand):
    """Задача очищает весь кэш приложения в Redis"""

    def handle(self, *args, **options):
        all_keys_mask = '%s:*' % settings.REDIS_KEY_PREFIX
        all_keys = redis_connection.keys(all_keys_mask)
        if all_keys:
            redis_connection.delete(*all_keys)
