# -*- coding: utf-8 -*-

import os
import requests

from django_docopt_command import DocOptCommand
from django.conf import settings

from passport_grants_configurator.apps.core.models import (
    Action,
    ActiveAction,
    ActiveNetwork,
    Consumer,
    Environment,
    Grant,
    Namespace,
    Network,
)
from passport_grants_configurator.apps.core.network_apis import NetworkResolver

OAUTH_RAW_GRANTS_LOCATION = 'https://github.yandex-team.ru/passport/oauth/raw/master/oauth_settings'
NETWORK_MAPPING = {
    'passport:mail-api:settings-read': '_C_PASSPORT_FRONT_STABLE_',
    'passport:abook:read': '_C_PASSPORT_FRONT_STABLE_',
    'passport:mail-api:rpop-read': '_C_PASSPORT_FRONT_STABLE_',
    'passport:mail-api:meta-read': '_C_PASSPORT_FRONT_STABLE_',
    'passport:mail-api:filter-read': '_C_PASSPORT_FRONT_STABLE_',
}


class Command(DocOptCommand):
    docs = '''usage: oauth_import_grants_from_git'''

    def handle_docopt(self, arguments):
        oauth = Namespace.objects.get(name='oauth')
        file_names = settings.PROJECTS['oauth']['file_names']

        # Для каждого окружения
        for (namespace_name, env_name, env_type), file_ in file_names.items():
            filename = file_.split('/')[1]
            path = os.path.join(OAUTH_RAW_GRANTS_LOCATION, filename)
            grants = requests.get(path).json()
            environment = Environment.objects.get(name=env_name, type=env_type)
            # Для каждого потребителя
            for consumer_name, meta_grants in grants.items():
                consumer, _ = Consumer.objects.get_or_create(name=consumer_name, namespace=oauth)
                # Перебираем его список грантов из описания из гита
                for grant_name, meta_grant in meta_grants['grants'].items():
                    grant, _ = Grant.objects.get_or_create(name=grant_name, namespace=oauth)
                    # И добавляем потребителю эти гранты
                    if grant_name == 'client' and '*' in meta_grant:
                        action, _ = Action.objects.get_or_create(name='all', grant=grant)
                        ActiveAction.objects.create(consumer=consumer, action=action, environment=environment)
                    else:
                        for action_name in meta_grant:
                            action, _ = Action.objects.get_or_create(name=action_name, grant=grant)
                            ActiveAction.objects.create(consumer=consumer, action=action, environment=environment)

                # Присваиваем потребителю его сети из описания из гита
                if env_name == 'localhost' and env_type == 'production' and consumer_name in NETWORK_MAPPING:
                    network, _ = Network.objects.get_or_create(string=NETWORK_MAPPING[consumer_name], type=Network.FIREWALL)
                    ActiveNetwork.objects.create(consumer=consumer, network=network, environment=environment)

                else:
                    for network_string in meta_grants['networks']:
                        network, _ = Network.objects.get_or_create(string=network_string, type=NetworkResolver.get_type(network_string))
                        ActiveNetwork.objects.create(consumer=consumer, network=network, environment=environment)

        print('Download finished')
