# -*- coding: utf-8 -*-

from optparse import make_option

from django.core.management.base import BaseCommand, CommandError

from passport_grants_configurator.apps.core.models import Environment
from passport_grants_configurator.apps.core.utils import export_passport_grants_to_file


class Command(BaseCommand):
    help = 'Экспортирует гранты в SQL-скрипт для паспорта'
    option_list = BaseCommand.option_list + (
        make_option('-f',
                    '--file',
                    dest='filename',
                    help='Полное имя файла, в который следует экспортировать данные.',
                    metavar='FILE'),
        make_option('-n',
                    '--environment-name',
                    dest='environment_name',
                    help='Имя окружения, для которого следует импортировать гранты (intranet/localhost/stress)',
                    metavar='ENVIRONMENT_NAME'),
        make_option('-t',
                    '--environment-type',
                    dest='environment_type',
                    help='Тип окружения, для которого следует импортировать гранты (development/stress/testing/production)',
                    metavar='ENVIRONMENT_TYPE'),
    )

    def handle(self, *args, **options):
        try:
            environment_name = options['environment_name']
            environment_type = options['environment_type']
        except AttributeError:
            raise CommandError('Пожалуйста, укажите окружение в параметрах (-n имя окружения -t тип окружения)')

        try:
            environment = Environment.objects.get(name=environment_name, type=environment_type)
        except Environment.DoesNotExist:
            raise CommandError('Пожалуйста, укажите существующее окружение')

        try:
            file_ = open(options['filename'], 'w')
        except IOError:
            raise CommandError('Нет доступа к файлу')
        except IndexError:
            raise CommandError('Пожалуйста, укажите полное имя файла в параметрах')

        export_passport_grants_to_file(environment=environment, file_=file_)
