# -*- coding: utf-8 -*-

import json
import os
import requests
from optparse import make_option

from django.core.management.base import BaseCommand

from passport_grants_configurator.apps.core.models import (
    Action,
    ActiveAction,
    ActiveMacros,
    ActiveNetwork,
    Consumer,
    Environment,
    Grant,
    Macros,
    Namespace,
    Network,
)
from passport_grants_configurator.apps.core.network_apis import get_network_type


class Command(BaseCommand):
    help = u'Удаляет все данные и загружает из git-репозитория паспортных грантов'
    option_list = BaseCommand.option_list + (
        make_option('--real_run',
                    action='store_true',
                    dest='real_run',
                    default=False,
                    help=u'Этот ключ необходим для запуска команды'),
    )

    def handle(self, *args, **options):
        if not options['real_run']:
            print u'Эта команда перед началом работы удаляет текущие гранты, для запуска необходим ключ --real_run'
            exit()

        passport, _ = Namespace.objects.get_or_create(name='passport')

        Consumer.objects.filter(namespace=passport).delete()
        Macros.objects.filter(namespace=passport).delete()
        ActiveMacros.objects.select_related().filter(consumer__namespace=passport).delete()
        ActiveAction.objects.select_related().filter(consumer__namespace=passport).delete()
        Action.objects.filter(grant__namespace=passport).delete()
        ActiveNetwork.objects.select_related().filter(consumer__namespace=passport).delete()

        print(u'Downloading consumer grants')

        filenames = {
            ('localhost', 'production', 1): 'consumer_grants.production.json',
            ('localhost', 'testing', 2): 'consumer_grants.testing.json',
            ('localhost', 'development', 3): 'consumer_grants.development.json',
            ('intranet', 'production', 4): 'consumer_grants.intranet.production.json',
            ('intranet', 'testing', 5): 'consumer_grants.intranet.testing.json',
            ('intranet', 'development', 6): 'consumer_grants.intranet.development.json',
            ('stress', 'stress', 7): 'consumer_grants.stress.stress.json',
        }

        # Для каждого окружения
        for (env_name, env_type, env_priority), file in filenames.items():
            grants_raw = requests.get(os.path.join('https://github.yandex-team.ru/passport/passport-grants/raw/master/grants/', file)).text
            with open(file, 'w') as f:
                f.write(grants_raw)
            grants = json.loads(grants_raw)
            environment, _ = Environment.objects.get_or_create(name=env_name, type=env_type, priority=env_priority)
            # Для каждого потребителя
            for consumer_name, meta_grants in grants.items():
                consumer, _ = Consumer.objects.get_or_create(name=consumer_name, namespace=passport)
                # Перебираем его список грантов из описания из гита
                for grant_name, meta_grant in meta_grants['grants'].items():
                    grant, _ = Grant.objects.get_or_create(name=grant_name, namespace=passport)
                    # И добавляем потребителю эти гранты
                    if grant_name != 'subscription':
                        for action_name in meta_grant:
                            action, _ = Action.objects.get_or_create(name=action_name, grant=grant)
                            ActiveAction.objects.create(consumer=consumer, action=action, environment=environment)
                    # Или гранты на подписку, которые создаются по одному в виде "севис.экшон" из дерева subscription: {сервис:[экшон1, экшон2..]}
                    else:
                        for service_name, action_names in meta_grant.items():
                            for action_name in action_names:
                                action, _ = Action.objects.get_or_create(name=service_name + '.' + action_name, grant=grant)
                                ActiveAction.objects.create(consumer=consumer, action=action, environment=environment)
                # Присваиваем потребителю его сети из описания из гита
                for network_string in meta_grants['networks']:
                    network, _ = Network.objects.get_or_create(string=network_string, type=get_network_type(network_string))
                    ActiveNetwork.objects.create(consumer=consumer, network=network, environment=environment)

        print('Download finished')
