# -*- coding: utf-8 -*-

import json
import socket
from optparse import make_option

from django.core.management.base import BaseCommand

from passport_grants_configurator.apps.core.models import (
    ActiveNetwork,
    Consumer,
    Environment,
    Network,
)


class Command(BaseCommand):
    help = 'Replaces consumer ips with their hosts'
    option_list = BaseCommand.option_list + (
        make_option('--real_run',
                    action='store_true',
                    dest='real_run',
                    default=False,
                    help='This key is required to modify any actual data in the database'),
        make_option('--delete_unresolved',
                    action='store_true',
                    dest='delete_unresolved',
                    default=False,
                    help=''.join([
                        'This key allows to delete all ips which cannot be resolved.',
                        'In this mode command only deletes unresolvable ips without any changes to any other, so to actually resolve',
                        'ips and write their host name into database you should also use this command without --delete_unresolved option',
                    ]))
    )

    def handle(self, *args, **options):
        unresolved_networks = {}
        for consumer in Consumer.objects.all():
            for environment in Environment.objects.all():
                # Для каждого потребителя каждого окружения получаем все его сети
                networks = list(set((an.network.string, an.network.type) for an in ActiveNetwork.objects.filter(environment=environment, consumer=consumer)))
                if networks:
                    print
                    print consumer, environment
                    print [network[0] for network in networks]
                    print '------------------------'
                # Cоздаем новый список сетей потребителя
                new_networks = set()
                # Резолвящиеся IP записываем в новый список, как хост
                # Нерезолвящиеся или не IP (по дефолту) добавляем так, как есть
                for network, type_ in networks:
                    if type_ == Network.IP:
                        try:
                            host, _, host_ips = socket.gethostbyaddr(network)
                            new_networks.add((host, Network.HOSTNAME))
                            if not options['delete_unresolved']:
                                print 'changing "%s" to "%s" (%s)' % (network, host, host_ips)
                        except socket.herror:
                            print 'can\'t resolve ' + network
                            new_networks.add((network, Network.IP))
                            unresolved_networks.setdefault(network, []).append('%s %s' % (str(consumer), str(environment)))
                    else:
                        new_networks.add((network, type_))
                # Отвязываем все сети потребителя в окружении, и добавляем ему все из нового списка
                if options['real_run'] and not options['delete_unresolved']:
                    ActiveNetwork.objects.filter(environment=environment, consumer=consumer).delete()
                    # Добавляем связи между потребителем и новым списком сетей, попутно создавая несуществующие
                    for string, type_ in new_networks:
                        network, _ = Network.objects.get_or_create(string=string, type=type_)
                        ActiveNetwork.objects.create(network=network, consumer=consumer, environment=environment)

        print '\nUnresolved networks:'
        print json.dumps(unresolved_networks, sort_keys=True, indent=4)
        if options['delete_unresolved']:
            for string in set(unresolved_networks):
                network = Network.objects.get(string=string)
                print "deleting " + str(network)
                if options['real_run']:
                    network.delete()
                    print 'network deleted'
