# -*- coding: utf-8 -*-
from __future__ import unicode_literals

import os
from datetime import datetime

from django_docopt_command import DocOptCommand
from sh import wget, python

from coverage_diff import parse_coverage, DictDiffer, diff_to_html

MASTER_COVERAGE = 'https://jenkins.yandex-team.ru/static-userContent/Passport-grants-configurator/coverage/index.html'
BASE_DIR = '/tmp/coverage/'
BASE_URL = 'http://coverage.passportdev-python.yandex.net/'


class Command(DocOptCommand):
    docs = '''usage: run_coverage'''

    def handle_docopt(self, arguments):
        current_user = os.environ.get('USER', os.environ.get('LOGNAME', 'root'))
        now = datetime.now()

        current_subdir = '{}/{}/{}/'.format(current_user, now.date(), now.time())
        current_dir = os.path.join(BASE_DIR, current_subdir)
        current_url = os.path.join(BASE_URL, current_subdir)

        upstream_dir = os.path.join(BASE_DIR , current_subdir, 'master')
        upstream_coverage_file = os.path.join(upstream_dir, 'master.html')

        os.makedirs(upstream_dir)
        wget(MASTER_COVERAGE, output_document=upstream_coverage_file)

        python(
            'manage.py',
            'test',
            with_coverage=True,
            cover_tests=True,
            cover_html=True,
            cover_html_dir=current_dir,
        )

        print('\n\n' + '//////////' * 12)
        print('Generated coverage HTML files are in directory ' + current_dir)
        print('Shared at: ' + current_url)

        diff = DictDiffer(old=parse_coverage(upstream_coverage_file), new=parse_coverage(current_url))
        html = diff_to_html(diff, upstream_coverage_file, current_url)
        if html:
            coverage_changes_file = os.path.join(current_dir, 'coverage-changes.html')
            open(coverage_changes_file, 'w').write(html)
            print 'Coverage changes shared at: ' + os.path.join(current_url, 'coverage-changes.html')
        else:
            print 'Coverage not changed'

        print('//////////' * 12 + '\n\n')
