# -*- coding: utf-8 -*-
from django_docopt_command import DocOptCommand

from passport_grants_configurator.apps.core.models import (
    Action,
    Environment,
    Grant,
    Namespace,
    Consumer,
    ActiveAction,
    ActiveNetwork,
)


class Command(DocOptCommand):
    docs = """
        Usage:
            yasms_add_default
            yasms_add_default (-e | --environment) <type>...
            yasms_add_default (-h | --help)

        Options:
            -h --help           Show this screen
        """

    help = u'Добавляем потребителям без роута Ясмс грант Route.default'

    def handle_docopt(self, arguments):
        yasms_namespace = Namespace.objects.get(name='yasms')

        consumers = Consumer.objects.filter(namespace=yasms_namespace)

        grant = Grant.objects.get(name='Route', namespace=yasms_namespace)
        action = Action.objects.get(name='default', grant=grant)
        route_actions = Action.objects.filter(grant=grant)

        added_to = 0

        if arguments['<type>']:
            environments = Environment.objects.filter(name='localhost', type__in=arguments['<type>'])
        else:
            environments = yasms_namespace.environments.all()

        for environment in environments:
            for consumer in consumers:
                an = ActiveNetwork.objects.filter(consumer=consumer, environment=environment)
                if not an:
                    continue
                aa = ActiveAction.objects.filter(consumer=consumer, action__in=route_actions, environment=environment)
                if aa:
                    continue
                ActiveAction.objects.create(
                    consumer=consumer,
                    action=action,
                    environment=environment,
                )
                added_to += 1

        print('Successfully added Route.default to %d consumers' % added_to)
