# -*- coding: utf-8 -*-
import logging

from django.core.management.base import CommandError
from django_docopt_command import DocOptCommand

from passport_grants_configurator.apps.core.utils import Config
from passport_grants_configurator.apps.core.models import *

DESCRIPTIONS = {
    ('ApplyPhone', 'Yes'): 'Грант на ручку api/applyphone',
    ('AnonymSms', 'Yes'): 'Грант на анонимные смс (параметр phone)',
    ('AwesomeRegistrator', 'Yes'): 'Грант на withoutsms',
    ('CheckPhone', 'Yes'): 'Грант на ручку api/checkphone',
    ('CRMAPI', 'Yes'): '',
    ('DebugPhoneInfo', 'Yes'): 'Грант на ручку api/debugphoneinfo (только логины yandex-team/yndx)',
    ('DeletePhone', 'Yes'): 'Грант на ручку api/deletephone',
    ('DisableLimitsForTest', 'Yes'): 'Для тестовых пользователей отключает проверку на bindlimit и отвязку',
    ('DropPhone', 'Yes'): '',
    ('HaveUserOnceValidatedPhone', 'Yes'): 'Грант на ручку haveuseroncevalidatedphone',
    ('Langdetect', 'Yes'): '',
    ('MobileAuth', 'Yes'): 'Мобильная аутентификация (параметр mobileauth)',
    ('ProlongValid', 'Yes'): 'Грант на ручку api/prolongvalid',
    ('Registrator', 'Yes'): 'Грант на ручки confirm, getunconfirmed и register',
    ('RemoveUserPhones', 'Yes'): 'Грант на ручку api/removeuserphones',
    ('RetFullPhone', 'Yes'): 'Грант на раскрытие номеров',
    ('Route', 'Default'): '',
    ('Route', 'Mobilemaps'): '',
    ('Route', 'Telesign'): '',
    ('Route', 'Test'): '',
    ('Route', 'Validate'): '',
    ('Routes', 'Yes'): 'Грант на доступный rule',
    ('SavePhone', 'Yes'): 'Грант на сохранение телефонного номера',
    ('SetPending', 'Yes'): 'Грант на ручку api/setpending (только логины yandex-team/yndx)',
    ('ShowMinorPhones', 'Yes'): '',
    ('SmsFromUid', 'Yes'): 'Грант на from_uid',
    ('UserPhones', 'Yes'): 'Грант на ручку userphones',
    ('ValidationsNumberOfUserPhones', 'Yes'): 'Возможность узнать количество подтверждений каждого телефонна у пользователя',
}

logger = logging.getLogger(__name__)


class Command(DocOptCommand):
    docs = '''
    Usage: yasms_import_perl_grants (-f | --file) <file> (-n | --environment-name) <name>  (-t | --environment-type) <type>
    '''

    def handle_docopt(self, arguments):
        namespace, _ = Namespace.objects.get_or_create(name='yasms')

        try:
            environment = Environment.objects.get(name=arguments['<name>'], type=arguments['<type>'])
            namespace.environments.add(environment)
        except Environment.DoesNotExist:
            raise CommandError('Please provide existing environment name and type in paremeters')

        with open(arguments['<file>']) as f:
            config = Config(f)

        for consumer_name, grants in config['Sender'].iteritems():
            networks = []
            actions = []
            consumer, _ = Consumer.objects.get_or_create(name=consumer_name, namespace=namespace)
            networks += [Network.objects.get_or_create(string=s, type=Network.IP)[0] for s in grants.pop('IP', [])]
            networks += [Network.objects.get_or_create(string=s, type=Network.IPNETWORK)[0] for s in grants.pop('SUBNET', [])]

            for grant_name, action_names in grants.items():
                if not action_names:
                    action_names = ['Yes']
                    logger.debug('Added "Yes" to %s for %s', grant_name, consumer_name)
                grant, _ = Grant.objects.get_or_create(name=grant_name, namespace=namespace)
                for name in action_names:
                    if name.lower() in ['yes', 'on', 'true']:
                        name = 'Yes'
                    action, _ = Action.objects.get_or_create(name=name, grant=grant)
                    action.description = DESCRIPTIONS.get((grant_name, name), '')
                    action.save()
                    actions += [action]

            for network in networks:
                ActiveNetwork.objects.get_or_create(consumer=consumer, network=network, environment=environment)

            for action in actions:
                ActiveAction.objects.get_or_create(consumer=consumer, action=action, environment=environment)
