# -*- coding: utf-8 -*-
from __future__ import unicode_literals
import os
import logging

import requests
from django.core.management import call_command
from django_docopt_command import DocOptCommand

from passport_grants_configurator.apps.core.models import *

logger = logging.getLogger(__name__)

FILES_BASE = 'https://github.yandex-team.ru/passport/yasms-grants/raw/master/grants/'

ENV_TO_FILENAME = {
    ('localhost', 'production', 1): 'access.prod.tt',
    ('localhost', 'testing', 2): 'access.test.tt',
    ('localhost', 'development', 3): 'access.dev.tt',
    ('localhost', 'rc', 9): 'access.rc.tt',
}


class Command(DocOptCommand):
    docs = '''Usage: yasms_load_grants_from_git --real_run'''

    def handle_docopt(self, arguments):
        yasms, _ = Namespace.objects.get_or_create(name='yasms')

        Consumer.objects.filter(namespace=yasms).delete()
        ActiveMacros.objects.select_related().filter(consumer__namespace=yasms).delete()
        ActiveAction.objects.select_related().filter(consumer__namespace=yasms).delete()
        ActiveNetwork.objects.select_related().filter(consumer__namespace=yasms).delete()

        # TODO: Получить весь репозиторий и взять нужные файлы
        logger.debug('Downloading consumer grants from %s', FILES_BASE)
        for (env_name, env_type, env_priority), filename in ENV_TO_FILENAME.items():
            url = os.path.join(FILES_BASE, filename)
            grants_raw = requests.get(url).text
            with open(filename, 'w') as f:
                f.write(grants_raw)

            Environment.objects.get_or_create(name=env_name, type=env_type, priority=env_priority)

            call_command('yasms_import_perl_grants', **{'<file>': filename, '<name>': env_name, '<type>': env_type})

            os.remove(filename)
