# -*- coding: utf-8 -*-
from __future__ import unicode_literals
import os
import shutil
import logging

from django.core.management import call_command
from django_docopt_command import DocOptCommand
from sh import svn

from passport_grants_configurator.apps.core.models import *

logger = logging.getLogger(__name__)

SVN_BASE = 'https://svn.yandex.ru/yasms/trunk/conf/templates'

# FIXME: Дублирование с yasms_load_grants_from_git
ENV_TO_FILENAME = {
    ('localhost', 'production', 1): 'access.prod.tt',
    ('localhost', 'testing', 2): 'access.test.tt',
    ('localhost', 'development', 3): 'access.dev.tt',
    ('localhost', 'rc', 9): 'access.rc.tt',
}

WORK_DIR = '/tmp/templates/'


class Command(DocOptCommand):
    docs = '''Usage: yasms_load_grants_from_svn --real_run'''

    def handle_docopt(self, arguments):
        svn_password = os.environ.get('YASMS_SVN_PASSWD')
        if not svn_password:
            raise Exception('Couldnt find YASMS_SVN_PASSWD environment variable')

        yasms, _ = Namespace.objects.get_or_create(name='yasms')

        Consumer.objects.filter(namespace=yasms).delete()
        Action.objects.select_related('grant').filter(grant__namespace=yasms).delete()
        Macros.objects.filter(namespace=yasms).delete()
        ActiveMacros.objects.select_related().filter(consumer__namespace=yasms).delete()
        ActiveAction.objects.select_related().filter(consumer__namespace=yasms).delete()
        ActiveNetwork.objects.select_related().filter(consumer__namespace=yasms).delete()

        logger.debug('Downloading consumer grants from %s', SVN_BASE)
        os.chdir('/tmp')
        stdout = svn.co(
            SVN_BASE,
            WORK_DIR,
            username='passport',
            password=svn_password,
            no_auth_cache=True,
            non_interactive=True,
            trust_server_cert=True,
        )
        logger.debug(stdout)

        for (env_name, env_type, env_priority), filename in ENV_TO_FILENAME.items():
            Environment.objects.get_or_create(name=env_name, type=env_type, priority=env_priority)

            call_command(
                'yasms_import_perl_grants',
                **{
                    '<file>': os.path.join(WORK_DIR, filename),
                    '<name>': env_name,
                    '<type>': env_type,
                }
            )

        shutil.rmtree(WORK_DIR)
