# -*- coding: utf-8 -*-
import datetime
from south.db import db
from south.v2 import SchemaMigration
from django.db import models


class Migration(SchemaMigration):

    def forwards(self, orm):
        # Adding model 'Namespace'
        db.create_table(u'core_namespace', (
            (u'id', self.gf('django.db.models.fields.AutoField')(primary_key=True)),
            ('name', self.gf('django.db.models.fields.CharField')(max_length=16)),
        ))
        db.send_create_signal(u'core', ['Namespace'])

        # Adding model 'Network'
        db.create_table(u'core_network', (
            (u'id', self.gf('django.db.models.fields.AutoField')(primary_key=True)),
            ('string', self.gf('django.db.models.fields.CharField')(max_length=256)),
        ))
        db.send_create_signal(u'core', ['Network'])

        # Adding model 'Consumer'
        db.create_table(u'core_consumer', (
            (u'id', self.gf('django.db.models.fields.AutoField')(primary_key=True)),
            ('name', self.gf('django.db.models.fields.CharField')(max_length=16)),
            ('namespace', self.gf('django.db.models.fields.related.ForeignKey')(to=orm['core.Namespace'])),
            ('description', self.gf('django.db.models.fields.CharField')(max_length=256)),
        ))
        db.send_create_signal(u'core', ['Consumer'])

        # Adding unique constraint on 'Consumer', fields ['name', 'namespace']
        db.create_unique(u'core_consumer', ['name', 'namespace_id'])

        # Adding M2M table for field network on 'Consumer'
        db.create_table(u'core_consumer_network', (
            ('id', models.AutoField(verbose_name='ID', primary_key=True, auto_created=True)),
            ('consumer', models.ForeignKey(orm[u'core.consumer'], null=False)),
            ('network', models.ForeignKey(orm[u'core.network'], null=False))
        ))
        db.create_unique(u'core_consumer_network', ['consumer_id', 'network_id'])

        # Adding model 'Grant'
        db.create_table(u'core_grant', (
            (u'id', self.gf('django.db.models.fields.AutoField')(primary_key=True)),
            ('name', self.gf('django.db.models.fields.CharField')(max_length=16)),
            ('namespace', self.gf('django.db.models.fields.related.ForeignKey')(to=orm['core.Namespace'])),
            ('description', self.gf('django.db.models.fields.CharField')(max_length=256)),
        ))
        db.send_create_signal(u'core', ['Grant'])

        # Adding unique constraint on 'Grant', fields ['name', 'namespace']
        db.create_unique(u'core_grant', ['name', 'namespace_id'])

        # Adding model 'Action'
        db.create_table(u'core_action', (
            (u'id', self.gf('django.db.models.fields.AutoField')(primary_key=True)),
            ('name', self.gf('django.db.models.fields.CharField')(max_length=16)),
            ('grant', self.gf('django.db.models.fields.related.ForeignKey')(to=orm['core.Grant'])),
        ))
        db.send_create_signal(u'core', ['Action'])

        # Adding model 'Macros'
        db.create_table(u'core_macros', (
            (u'id', self.gf('django.db.models.fields.AutoField')(primary_key=True)),
            ('name', self.gf('django.db.models.fields.CharField')(max_length=16)),
            ('description', self.gf('django.db.models.fields.CharField')(max_length=256)),
        ))
        db.send_create_signal(u'core', ['Macros'])

        # Adding M2M table for field action on 'Macros'
        db.create_table(u'core_macros_action', (
            ('id', models.AutoField(verbose_name='ID', primary_key=True, auto_created=True)),
            ('macros', models.ForeignKey(orm[u'core.macros'], null=False)),
            ('action', models.ForeignKey(orm[u'core.action'], null=False))
        ))
        db.create_unique(u'core_macros_action', ['macros_id', 'action_id'])

        # Adding model 'ActiveMacros'
        db.create_table(u'core_activemacros', (
            (u'id', self.gf('django.db.models.fields.AutoField')(primary_key=True)),
            ('consumer', self.gf('django.db.models.fields.related.ForeignKey')(to=orm['core.Consumer'])),
            ('macros', self.gf('django.db.models.fields.related.ForeignKey')(to=orm['core.Macros'])),
        ))
        db.send_create_signal(u'core', ['ActiveMacros'])

        # Adding unique constraint on 'ActiveMacros', fields ['consumer', 'macros']
        db.create_unique(u'core_activemacros', ['consumer_id', 'macros_id'])

        # Adding model 'ActiveGrant'
        db.create_table(u'core_activegrant', (
            (u'id', self.gf('django.db.models.fields.AutoField')(primary_key=True)),
            ('consumer', self.gf('django.db.models.fields.related.ForeignKey')(to=orm['core.Consumer'])),
            ('action', self.gf('django.db.models.fields.related.ForeignKey')(to=orm['core.Action'])),
        ))
        db.send_create_signal(u'core', ['ActiveGrant'])

        # Adding unique constraint on 'ActiveGrant', fields ['consumer', 'action']
        db.create_unique(u'core_activegrant', ['consumer_id', 'action_id'])

        # Adding model 'Query'
        db.create_table(u'core_query', (
            (u'id', self.gf('django.db.models.fields.AutoField')(primary_key=True)),
            ('creator', self.gf('django.db.models.fields.related.ForeignKey')(related_name='creator', to=orm['auth.User'])),
            ('creation_date', self.gf('django.db.models.fields.DateTimeField')(auto_now_add=True, blank=True)),
            ('approving_person', self.gf('django.db.models.fields.related.ForeignKey')(related_name='approving_person', to=orm['auth.User'])),
            ('approving_date', self.gf('django.db.models.fields.DateTimeField')(auto_now=True, blank=True)),
            ('consumer', self.gf('django.db.models.fields.related.ForeignKey')(to=orm['core.Consumer'])),
            ('status', self.gf('django.db.models.fields.CharField')(default='N', max_length=2)),
        ))
        db.send_create_signal(u'core', ['Query'])

        # Adding M2M table for field action on 'Query'
        db.create_table(u'core_query_action', (
            ('id', models.AutoField(verbose_name='ID', primary_key=True, auto_created=True)),
            ('query', models.ForeignKey(orm[u'core.query'], null=False)),
            ('action', models.ForeignKey(orm[u'core.action'], null=False))
        ))
        db.create_unique(u'core_query_action', ['query_id', 'action_id'])

        # Adding M2M table for field macros on 'Query'
        db.create_table(u'core_query_macros', (
            ('id', models.AutoField(verbose_name='ID', primary_key=True, auto_created=True)),
            ('query', models.ForeignKey(orm[u'core.query'], null=False)),
            ('macros', models.ForeignKey(orm[u'core.macros'], null=False))
        ))
        db.create_unique(u'core_query_macros', ['query_id', 'macros_id'])

    def backwards(self, orm):
        # Removing unique constraint on 'ActiveGrant', fields ['consumer', 'action']
        db.delete_unique(u'core_activegrant', ['consumer_id', 'action_id'])

        # Removing unique constraint on 'ActiveMacros', fields ['consumer', 'macros']
        db.delete_unique(u'core_activemacros', ['consumer_id', 'macros_id'])

        # Removing unique constraint on 'Grant', fields ['name', 'namespace']
        db.delete_unique(u'core_grant', ['name', 'namespace_id'])

        # Removing unique constraint on 'Consumer', fields ['name', 'namespace']
        db.delete_unique(u'core_consumer', ['name', 'namespace_id'])

        # Deleting model 'Namespace'
        db.delete_table(u'core_namespace')

        # Deleting model 'Network'
        db.delete_table(u'core_network')

        # Deleting model 'Consumer'
        db.delete_table(u'core_consumer')

        # Removing M2M table for field network on 'Consumer'
        db.delete_table('core_consumer_network')

        # Deleting model 'Grant'
        db.delete_table(u'core_grant')

        # Deleting model 'Action'
        db.delete_table(u'core_action')

        # Deleting model 'Macros'
        db.delete_table(u'core_macros')

        # Removing M2M table for field action on 'Macros'
        db.delete_table('core_macros_action')

        # Deleting model 'ActiveMacros'
        db.delete_table(u'core_activemacros')

        # Deleting model 'ActiveGrant'
        db.delete_table(u'core_activegrant')

        # Deleting model 'Query'
        db.delete_table(u'core_query')

        # Removing M2M table for field action on 'Query'
        db.delete_table('core_query_action')

        # Removing M2M table for field macros on 'Query'
        db.delete_table('core_query_macros')

    models = {
        u'auth.group': {
            'Meta': {'object_name': 'Group'},
            u'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'name': ('django.db.models.fields.CharField', [], {'unique': 'True', 'max_length': '80'}),
            'permissions': ('django.db.models.fields.related.ManyToManyField', [], {'to': u"orm['auth.Permission']", 'symmetrical': 'False', 'blank': 'True'})
        },
        u'auth.permission': {
            'Meta': {'ordering': "(u'content_type__app_label', u'content_type__model', u'codename')", 'unique_together': "((u'content_type', u'codename'),)", 'object_name': 'Permission'},
            'codename': ('django.db.models.fields.CharField', [], {'max_length': '100'}),
            'content_type': ('django.db.models.fields.related.ForeignKey', [], {'to': u"orm['contenttypes.ContentType']"}),
            u'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'name': ('django.db.models.fields.CharField', [], {'max_length': '50'})
        },
        u'auth.user': {
            'Meta': {'object_name': 'User'},
            'date_joined': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now'}),
            'email': ('django.db.models.fields.EmailField', [], {'max_length': '75', 'blank': 'True'}),
            'first_name': ('django.db.models.fields.CharField', [], {'max_length': '30', 'blank': 'True'}),
            'groups': ('django.db.models.fields.related.ManyToManyField', [], {'to': u"orm['auth.Group']", 'symmetrical': 'False', 'blank': 'True'}),
            u'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'is_active': ('django.db.models.fields.BooleanField', [], {'default': 'True'}),
            'is_staff': ('django.db.models.fields.BooleanField', [], {'default': 'False'}),
            'is_superuser': ('django.db.models.fields.BooleanField', [], {'default': 'False'}),
            'last_login': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now'}),
            'last_name': ('django.db.models.fields.CharField', [], {'max_length': '30', 'blank': 'True'}),
            'password': ('django.db.models.fields.CharField', [], {'max_length': '128'}),
            'user_permissions': ('django.db.models.fields.related.ManyToManyField', [], {'to': u"orm['auth.Permission']", 'symmetrical': 'False', 'blank': 'True'}),
            'username': ('django.db.models.fields.CharField', [], {'unique': 'True', 'max_length': '30'})
        },
        u'contenttypes.contenttype': {
            'Meta': {'ordering': "('name',)", 'unique_together': "(('app_label', 'model'),)", 'object_name': 'ContentType', 'db_table': "'django_content_type'"},
            'app_label': ('django.db.models.fields.CharField', [], {'max_length': '100'}),
            u'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'model': ('django.db.models.fields.CharField', [], {'max_length': '100'}),
            'name': ('django.db.models.fields.CharField', [], {'max_length': '100'})
        },
        u'core.action': {
            'Meta': {'object_name': 'Action'},
            'grant': ('django.db.models.fields.related.ForeignKey', [], {'to': u"orm['core.Grant']"}),
            u'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'name': ('django.db.models.fields.CharField', [], {'max_length': '16'})
        },
        u'core.activegrant': {
            'Meta': {'unique_together': "(('consumer', 'action'),)", 'object_name': 'ActiveGrant'},
            'action': ('django.db.models.fields.related.ForeignKey', [], {'to': u"orm['core.Action']"}),
            'consumer': ('django.db.models.fields.related.ForeignKey', [], {'to': u"orm['core.Consumer']"}),
            u'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'})
        },
        u'core.activemacros': {
            'Meta': {'unique_together': "(('consumer', 'macros'),)", 'object_name': 'ActiveMacros'},
            'consumer': ('django.db.models.fields.related.ForeignKey', [], {'to': u"orm['core.Consumer']"}),
            u'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'macros': ('django.db.models.fields.related.ForeignKey', [], {'to': u"orm['core.Macros']"})
        },
        u'core.consumer': {
            'Meta': {'unique_together': "(('name', 'namespace'),)", 'object_name': 'Consumer'},
            'description': ('django.db.models.fields.CharField', [], {'max_length': '256'}),
            u'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'name': ('django.db.models.fields.CharField', [], {'max_length': '16'}),
            'namespace': ('django.db.models.fields.related.ForeignKey', [], {'to': u"orm['core.Namespace']"}),
            'network': ('django.db.models.fields.related.ManyToManyField', [], {'to': u"orm['core.Network']", 'symmetrical': 'False'})
        },
        u'core.grant': {
            'Meta': {'unique_together': "(('name', 'namespace'),)", 'object_name': 'Grant'},
            'description': ('django.db.models.fields.CharField', [], {'max_length': '256'}),
            u'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'name': ('django.db.models.fields.CharField', [], {'max_length': '16'}),
            'namespace': ('django.db.models.fields.related.ForeignKey', [], {'to': u"orm['core.Namespace']"})
        },
        u'core.macros': {
            'Meta': {'object_name': 'Macros'},
            'action': ('django.db.models.fields.related.ManyToManyField', [], {'to': u"orm['core.Action']", 'symmetrical': 'False'}),
            'description': ('django.db.models.fields.CharField', [], {'max_length': '256'}),
            u'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'name': ('django.db.models.fields.CharField', [], {'max_length': '16'})
        },
        u'core.namespace': {
            'Meta': {'object_name': 'Namespace'},
            u'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'name': ('django.db.models.fields.CharField', [], {'max_length': '16'})
        },
        u'core.network': {
            'Meta': {'object_name': 'Network'},
            u'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'string': ('django.db.models.fields.CharField', [], {'max_length': '256'})
        },
        u'core.query': {
            'Meta': {'object_name': 'Query'},
            'action': ('django.db.models.fields.related.ManyToManyField', [], {'to': u"orm['core.Action']", 'symmetrical': 'False'}),
            'approving_date': ('django.db.models.fields.DateTimeField', [], {'auto_now': 'True', 'blank': 'True'}),
            'approving_person': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'approving_person'", 'to': u"orm['auth.User']"}),
            'consumer': ('django.db.models.fields.related.ForeignKey', [], {'to': u"orm['core.Consumer']"}),
            'creation_date': ('django.db.models.fields.DateTimeField', [], {'auto_now_add': 'True', 'blank': 'True'}),
            'creator': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'creator'", 'to': u"orm['auth.User']"}),
            u'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'macros': ('django.db.models.fields.related.ManyToManyField', [], {'to': u"orm['core.Macros']", 'symmetrical': 'False'}),
            'status': ('django.db.models.fields.CharField', [], {'default': "'N'", 'max_length': '2'})
        }
    }

    complete_apps = ['core']
