# -*- coding: utf-8 -*-
import datetime
from south.db import db
from south.v2 import SchemaMigration
from django.db import models


class Migration(SchemaMigration):

    def forwards(self, orm):
        # Removing unique constraint on 'ActiveGrant', fields ['consumer', 'action']
        db.delete_unique('core_activegrant', ['consumer_id', 'action_id'])

        # Deleting model 'Query'
        db.delete_table('core_query')

        # Removing M2M table for field del_action on 'Query'
        db.delete_table('core_query_del_action')

        # Removing M2M table for field add_macros on 'Query'
        db.delete_table('core_query_add_macros')

        # Removing M2M table for field add_network on 'Query'
        db.delete_table('core_query_add_network')

        # Removing M2M table for field add_action on 'Query'
        db.delete_table('core_query_add_action')

        # Removing M2M table for field del_macros on 'Query'
        db.delete_table('core_query_del_macros')

        # Removing M2M table for field del_network on 'Query'
        db.delete_table('core_query_del_network')

        # Deleting model 'ActiveGrant'
        db.delete_table('core_activegrant')

        # Adding model 'Issue'
        db.create_table('core_issue', (
            ('id', self.gf('django.db.models.fields.AutoField')(primary_key=True)),
            ('creator', self.gf('django.db.models.fields.related.ForeignKey')(related_name='creator', to=orm['auth.User'])),
            ('creation_date', self.gf('django.db.models.fields.DateTimeField')(auto_now_add=True, blank=True)),
            ('approving_person', self.gf('django.db.models.fields.related.ForeignKey')(related_name='approving_person', to=orm['auth.User'])),
            ('approving_date', self.gf('django.db.models.fields.DateTimeField')(auto_now=True, blank=True)),
            ('consumer_and_networks', self.gf('django.db.models.fields.CharField')(max_length=2048)),
            ('status', self.gf('django.db.models.fields.CharField')(default='N', max_length=2)),
        ))
        db.send_create_signal('core', ['Issue'])

        # Adding M2M table for field add_action on 'Issue'
        db.create_table('core_issue_add_action', (
            ('id', models.AutoField(verbose_name='ID', primary_key=True, auto_created=True)),
            ('issue', models.ForeignKey(orm['core.issue'], null=False)),
            ('action', models.ForeignKey(orm['core.action'], null=False))
        ))
        db.create_unique('core_issue_add_action', ['issue_id', 'action_id'])

        # Adding M2M table for field del_action on 'Issue'
        db.create_table('core_issue_del_action', (
            ('id', models.AutoField(verbose_name='ID', primary_key=True, auto_created=True)),
            ('issue', models.ForeignKey(orm['core.issue'], null=False)),
            ('action', models.ForeignKey(orm['core.action'], null=False))
        ))
        db.create_unique('core_issue_del_action', ['issue_id', 'action_id'])

        # Adding M2M table for field add_macros on 'Issue'
        db.create_table('core_issue_add_macros', (
            ('id', models.AutoField(verbose_name='ID', primary_key=True, auto_created=True)),
            ('issue', models.ForeignKey(orm['core.issue'], null=False)),
            ('macros', models.ForeignKey(orm['core.macros'], null=False))
        ))
        db.create_unique('core_issue_add_macros', ['issue_id', 'macros_id'])

        # Adding M2M table for field del_macros on 'Issue'
        db.create_table('core_issue_del_macros', (
            ('id', models.AutoField(verbose_name='ID', primary_key=True, auto_created=True)),
            ('issue', models.ForeignKey(orm['core.issue'], null=False)),
            ('macros', models.ForeignKey(orm['core.macros'], null=False))
        ))
        db.create_unique('core_issue_del_macros', ['issue_id', 'macros_id'])

        # Adding model 'ActiveAction'
        db.create_table('core_activeaction', (
            ('id', self.gf('django.db.models.fields.AutoField')(primary_key=True)),
            ('consumer', self.gf('django.db.models.fields.related.ForeignKey')(to=orm['core.Consumer'])),
            ('action', self.gf('django.db.models.fields.related.ForeignKey')(to=orm['core.Action'])),
        ))
        db.send_create_signal('core', ['ActiveAction'])

        # Adding unique constraint on 'ActiveAction', fields ['consumer', 'action']
        db.create_unique('core_activeaction', ['consumer_id', 'action_id'])


    def backwards(self, orm):
        # Removing unique constraint on 'ActiveAction', fields ['consumer', 'action']
        db.delete_unique('core_activeaction', ['consumer_id', 'action_id'])

        # Adding model 'Query'
        db.create_table('core_query', (
            ('status', self.gf('django.db.models.fields.CharField')(default='N', max_length=2)),
            ('creator', self.gf('django.db.models.fields.related.ForeignKey')(related_name='creator', to=orm['auth.User'])),
            ('creation_date', self.gf('django.db.models.fields.DateTimeField')(auto_now_add=True, blank=True)),
            ('approving_date', self.gf('django.db.models.fields.DateTimeField')(auto_now=True, blank=True)),
            ('id', self.gf('django.db.models.fields.AutoField')(primary_key=True)),
            ('approving_person', self.gf('django.db.models.fields.related.ForeignKey')(related_name='approving_person', to=orm['auth.User'])),
            ('consumer', self.gf('django.db.models.fields.related.ForeignKey')(to=orm['core.Consumer'])),
        ))
        db.send_create_signal('core', ['Query'])

        # Adding M2M table for field del_action on 'Query'
        db.create_table('core_query_del_action', (
            ('id', models.AutoField(verbose_name='ID', primary_key=True, auto_created=True)),
            ('query', models.ForeignKey(orm['core.query'], null=False)),
            ('action', models.ForeignKey(orm['core.action'], null=False))
        ))
        db.create_unique('core_query_del_action', ['query_id', 'action_id'])

        # Adding M2M table for field add_macros on 'Query'
        db.create_table('core_query_add_macros', (
            ('id', models.AutoField(verbose_name='ID', primary_key=True, auto_created=True)),
            ('query', models.ForeignKey(orm['core.query'], null=False)),
            ('macros', models.ForeignKey(orm['core.macros'], null=False))
        ))
        db.create_unique('core_query_add_macros', ['query_id', 'macros_id'])

        # Adding M2M table for field add_network on 'Query'
        db.create_table('core_query_add_network', (
            ('id', models.AutoField(verbose_name='ID', primary_key=True, auto_created=True)),
            ('query', models.ForeignKey(orm['core.query'], null=False)),
            ('network', models.ForeignKey(orm['core.network'], null=False))
        ))
        db.create_unique('core_query_add_network', ['query_id', 'network_id'])

        # Adding M2M table for field add_action on 'Query'
        db.create_table('core_query_add_action', (
            ('id', models.AutoField(verbose_name='ID', primary_key=True, auto_created=True)),
            ('query', models.ForeignKey(orm['core.query'], null=False)),
            ('action', models.ForeignKey(orm['core.action'], null=False))
        ))
        db.create_unique('core_query_add_action', ['query_id', 'action_id'])

        # Adding M2M table for field del_macros on 'Query'
        db.create_table('core_query_del_macros', (
            ('id', models.AutoField(verbose_name='ID', primary_key=True, auto_created=True)),
            ('query', models.ForeignKey(orm['core.query'], null=False)),
            ('macros', models.ForeignKey(orm['core.macros'], null=False))
        ))
        db.create_unique('core_query_del_macros', ['query_id', 'macros_id'])

        # Adding M2M table for field del_network on 'Query'
        db.create_table('core_query_del_network', (
            ('id', models.AutoField(verbose_name='ID', primary_key=True, auto_created=True)),
            ('query', models.ForeignKey(orm['core.query'], null=False)),
            ('network', models.ForeignKey(orm['core.network'], null=False))
        ))
        db.create_unique('core_query_del_network', ['query_id', 'network_id'])

        # Adding model 'ActiveGrant'
        db.create_table('core_activegrant', (
            ('action', self.gf('django.db.models.fields.related.ForeignKey')(to=orm['core.Action'])),
            ('consumer', self.gf('django.db.models.fields.related.ForeignKey')(to=orm['core.Consumer'])),
            ('id', self.gf('django.db.models.fields.AutoField')(primary_key=True)),
        ))
        db.send_create_signal('core', ['ActiveGrant'])

        # Adding unique constraint on 'ActiveGrant', fields ['consumer', 'action']
        db.create_unique('core_activegrant', ['consumer_id', 'action_id'])

        # Deleting model 'Issue'
        db.delete_table('core_issue')

        # Removing M2M table for field add_action on 'Issue'
        db.delete_table('core_issue_add_action')

        # Removing M2M table for field del_action on 'Issue'
        db.delete_table('core_issue_del_action')

        # Removing M2M table for field add_macros on 'Issue'
        db.delete_table('core_issue_add_macros')

        # Removing M2M table for field del_macros on 'Issue'
        db.delete_table('core_issue_del_macros')

        # Deleting model 'ActiveAction'
        db.delete_table('core_activeaction')


    models = {
        'auth.group': {
            'Meta': {'object_name': 'Group'},
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'name': ('django.db.models.fields.CharField', [], {'unique': 'True', 'max_length': '80'}),
            'permissions': ('django.db.models.fields.related.ManyToManyField', [], {'to': "orm['auth.Permission']", 'symmetrical': 'False', 'blank': 'True'})
        },
        'auth.permission': {
            'Meta': {'ordering': "('content_type__app_label', 'content_type__model', 'codename')", 'unique_together': "(('content_type', 'codename'),)", 'object_name': 'Permission'},
            'codename': ('django.db.models.fields.CharField', [], {'max_length': '100'}),
            'content_type': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['contenttypes.ContentType']"}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'name': ('django.db.models.fields.CharField', [], {'max_length': '50'})
        },
        'auth.user': {
            'Meta': {'object_name': 'User'},
            'date_joined': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now'}),
            'email': ('django.db.models.fields.EmailField', [], {'max_length': '75', 'blank': 'True'}),
            'first_name': ('django.db.models.fields.CharField', [], {'max_length': '30', 'blank': 'True'}),
            'groups': ('django.db.models.fields.related.ManyToManyField', [], {'to': "orm['auth.Group']", 'symmetrical': 'False', 'blank': 'True'}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'is_active': ('django.db.models.fields.BooleanField', [], {'default': 'True'}),
            'is_staff': ('django.db.models.fields.BooleanField', [], {'default': 'False'}),
            'is_superuser': ('django.db.models.fields.BooleanField', [], {'default': 'False'}),
            'last_login': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now'}),
            'last_name': ('django.db.models.fields.CharField', [], {'max_length': '30', 'blank': 'True'}),
            'password': ('django.db.models.fields.CharField', [], {'max_length': '128'}),
            'user_permissions': ('django.db.models.fields.related.ManyToManyField', [], {'to': "orm['auth.Permission']", 'symmetrical': 'False', 'blank': 'True'}),
            'username': ('django.db.models.fields.CharField', [], {'unique': 'True', 'max_length': '30'})
        },
        'contenttypes.contenttype': {
            'Meta': {'ordering': "('name',)", 'unique_together': "(('app_label', 'model'),)", 'object_name': 'ContentType', 'db_table': "'django_content_type'"},
            'app_label': ('django.db.models.fields.CharField', [], {'max_length': '100'}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'model': ('django.db.models.fields.CharField', [], {'max_length': '100'}),
            'name': ('django.db.models.fields.CharField', [], {'max_length': '100'})
        },
        'core.action': {
            'Meta': {'object_name': 'Action'},
            'description': ('django.db.models.fields.CharField', [], {'max_length': '256'}),
            'grant': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['core.Grant']"}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'name': ('django.db.models.fields.CharField', [], {'max_length': '64'})
        },
        'core.activeaction': {
            'Meta': {'unique_together': "(('consumer', 'action'),)", 'object_name': 'ActiveAction'},
            'action': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['core.Action']"}),
            'consumer': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['core.Consumer']"}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'})
        },
        'core.activemacros': {
            'Meta': {'unique_together': "(('consumer', 'macros'),)", 'object_name': 'ActiveMacros'},
            'consumer': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['core.Consumer']"}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'macros': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['core.Macros']"})
        },
        'core.consumer': {
            'Meta': {'unique_together': "(('name', 'namespace'),)", 'object_name': 'Consumer'},
            'description': ('django.db.models.fields.CharField', [], {'max_length': '256'}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'name': ('django.db.models.fields.CharField', [], {'max_length': '64'}),
            'namespace': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['core.Namespace']"}),
            'network': ('django.db.models.fields.related.ManyToManyField', [], {'to': "orm['core.Network']", 'symmetrical': 'False'})
        },
        'core.grant': {
            'Meta': {'unique_together': "(('name', 'namespace'),)", 'object_name': 'Grant'},
            'description': ('django.db.models.fields.CharField', [], {'max_length': '256'}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'name': ('django.db.models.fields.CharField', [], {'max_length': '64'}),
            'namespace': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['core.Namespace']"})
        },
        'core.issue': {
            'Meta': {'object_name': 'Issue'},
            'add_action': ('django.db.models.fields.related.ManyToManyField', [], {'related_name': "'add_action'", 'symmetrical': 'False', 'to': "orm['core.Action']"}),
            'add_macros': ('django.db.models.fields.related.ManyToManyField', [], {'related_name': "'add_macros'", 'symmetrical': 'False', 'to': "orm['core.Macros']"}),
            'approving_date': ('django.db.models.fields.DateTimeField', [], {'auto_now': 'True', 'blank': 'True'}),
            'approving_person': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'approving_person'", 'to': "orm['auth.User']"}),
            'consumer_and_networks': ('django.db.models.fields.CharField', [], {'max_length': '2048'}),
            'creation_date': ('django.db.models.fields.DateTimeField', [], {'auto_now_add': 'True', 'blank': 'True'}),
            'creator': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'creator'", 'to': "orm['auth.User']"}),
            'del_action': ('django.db.models.fields.related.ManyToManyField', [], {'related_name': "'del_action'", 'symmetrical': 'False', 'to': "orm['core.Action']"}),
            'del_macros': ('django.db.models.fields.related.ManyToManyField', [], {'related_name': "'del_macros'", 'symmetrical': 'False', 'to': "orm['core.Macros']"}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'status': ('django.db.models.fields.CharField', [], {'default': "'N'", 'max_length': '2'})
        },
        'core.macros': {
            'Meta': {'object_name': 'Macros'},
            'action': ('django.db.models.fields.related.ManyToManyField', [], {'to': "orm['core.Action']", 'symmetrical': 'False'}),
            'description': ('django.db.models.fields.CharField', [], {'max_length': '256'}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'name': ('django.db.models.fields.CharField', [], {'max_length': '64'})
        },
        'core.namespace': {
            'Meta': {'object_name': 'Namespace'},
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'name': ('django.db.models.fields.CharField', [], {'max_length': '64'})
        },
        'core.network': {
            'Meta': {'object_name': 'Network'},
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'string': ('django.db.models.fields.CharField', [], {'max_length': '256'})
        }
    }

    complete_apps = ['core']
