# -*- coding: utf-8 -*-
import datetime
from south.db import db
from south.v2 import SchemaMigration
from django.db import models


class Migration(SchemaMigration):

    def forwards(self, orm):
        # Removing unique constraint on 'ActiveAction', fields ['action', 'consumer']
        db.delete_unique('core_activeaction', ['action_id', 'consumer_id'])

        # Removing unique constraint on 'ActiveMacros', fields ['macros', 'consumer']
        db.delete_unique('core_activemacros', ['macros_id', 'consumer_id'])

        # Adding model 'Environment'
        db.create_table('core_environment', (
            ('id', self.gf('django.db.models.fields.AutoField')(primary_key=True)),
            ('description', self.gf('django.db.models.fields.CharField')(max_length=256)),
            ('name', self.gf('django.db.models.fields.CharField')(max_length=64)),
            ('type', self.gf('django.db.models.fields.CharField')(max_length=64)),
        ))
        db.send_create_signal('core', ['Environment'])

        # Adding model 'ActiveNetwork'
        db.create_table('core_activenetwork', (
            ('id', self.gf('django.db.models.fields.AutoField')(primary_key=True)),
            ('consumer', self.gf('django.db.models.fields.related.ForeignKey')(to=orm['core.Consumer'])),
            ('network', self.gf('django.db.models.fields.related.ForeignKey')(to=orm['core.Network'])),
            ('environment', self.gf('django.db.models.fields.related.ForeignKey')(to=orm['core.Environment'])),
        ))
        db.send_create_signal('core', ['ActiveNetwork'])

        # Adding unique constraint on 'ActiveNetwork', fields ['consumer', 'network', 'environment']
        db.create_unique('core_activenetwork', ['consumer_id', 'network_id', 'environment_id'])

        # Adding field 'ActiveMacros.environment'
        db.add_column('core_activemacros', 'environment',
                      self.gf('django.db.models.fields.related.ForeignKey')(default=-1, to=orm['core.Environment']),
                      keep_default=False)

        # Adding unique constraint on 'ActiveMacros', fields ['environment', 'macros', 'consumer']
        db.create_unique('core_activemacros', ['environment_id', 'macros_id', 'consumer_id'])

        # Adding field 'ActiveAction.environment'
        db.add_column('core_activeaction', 'environment',
                      self.gf('django.db.models.fields.related.ForeignKey')(default=-1, to=orm['core.Environment']),
                      keep_default=False)

        # Adding unique constraint on 'ActiveAction', fields ['action', 'environment', 'consumer']
        db.create_unique('core_activeaction', ['action_id', 'environment_id', 'consumer_id'])


    def backwards(self, orm):
        # Removing unique constraint on 'ActiveAction', fields ['action', 'environment', 'consumer']
        db.delete_unique('core_activeaction', ['action_id', 'environment_id', 'consumer_id'])

        # Removing unique constraint on 'ActiveMacros', fields ['environment', 'macros', 'consumer']
        db.delete_unique('core_activemacros', ['environment_id', 'macros_id', 'consumer_id'])

        # Removing unique constraint on 'ActiveNetwork', fields ['consumer', 'network', 'environment']
        db.delete_unique('core_activenetwork', ['consumer_id', 'network_id', 'environment_id'])

        # Deleting model 'Environment'
        db.delete_table('core_environment')

        # Deleting model 'ActiveNetwork'
        db.delete_table('core_activenetwork')

        # Deleting field 'ActiveMacros.environment'
        db.delete_column('core_activemacros', 'environment_id')

        # Adding unique constraint on 'ActiveMacros', fields ['macros', 'consumer']
        db.create_unique('core_activemacros', ['macros_id', 'consumer_id'])

        # Deleting field 'ActiveAction.environment'
        db.delete_column('core_activeaction', 'environment_id')

        # Adding unique constraint on 'ActiveAction', fields ['action', 'consumer']
        db.create_unique('core_activeaction', ['action_id', 'consumer_id'])


    models = {
        'auth.group': {
            'Meta': {'object_name': 'Group'},
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'name': ('django.db.models.fields.CharField', [], {'unique': 'True', 'max_length': '80'}),
            'permissions': ('django.db.models.fields.related.ManyToManyField', [], {'to': "orm['auth.Permission']", 'symmetrical': 'False', 'blank': 'True'})
        },
        'auth.permission': {
            'Meta': {'ordering': "('content_type__app_label', 'content_type__model', 'codename')", 'unique_together': "(('content_type', 'codename'),)", 'object_name': 'Permission'},
            'codename': ('django.db.models.fields.CharField', [], {'max_length': '100'}),
            'content_type': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['contenttypes.ContentType']"}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'name': ('django.db.models.fields.CharField', [], {'max_length': '50'})
        },
        'auth.user': {
            'Meta': {'object_name': 'User'},
            'date_joined': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now'}),
            'email': ('django.db.models.fields.EmailField', [], {'max_length': '75', 'blank': 'True'}),
            'first_name': ('django.db.models.fields.CharField', [], {'max_length': '30', 'blank': 'True'}),
            'groups': ('django.db.models.fields.related.ManyToManyField', [], {'to': "orm['auth.Group']", 'symmetrical': 'False', 'blank': 'True'}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'is_active': ('django.db.models.fields.BooleanField', [], {'default': 'True'}),
            'is_staff': ('django.db.models.fields.BooleanField', [], {'default': 'False'}),
            'is_superuser': ('django.db.models.fields.BooleanField', [], {'default': 'False'}),
            'last_login': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now'}),
            'last_name': ('django.db.models.fields.CharField', [], {'max_length': '30', 'blank': 'True'}),
            'password': ('django.db.models.fields.CharField', [], {'max_length': '128'}),
            'user_permissions': ('django.db.models.fields.related.ManyToManyField', [], {'to': "orm['auth.Permission']", 'symmetrical': 'False', 'blank': 'True'}),
            'username': ('django.db.models.fields.CharField', [], {'unique': 'True', 'max_length': '30'})
        },
        'contenttypes.contenttype': {
            'Meta': {'ordering': "('name',)", 'unique_together': "(('app_label', 'model'),)", 'object_name': 'ContentType', 'db_table': "'django_content_type'"},
            'app_label': ('django.db.models.fields.CharField', [], {'max_length': '100'}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'model': ('django.db.models.fields.CharField', [], {'max_length': '100'}),
            'name': ('django.db.models.fields.CharField', [], {'max_length': '100'})
        },
        'core.action': {
            'Meta': {'object_name': 'Action'},
            'description': ('django.db.models.fields.CharField', [], {'max_length': '256'}),
            'grant': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['core.Grant']"}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'name': ('django.db.models.fields.CharField', [], {'max_length': '64'})
        },
        'core.activeaction': {
            'Meta': {'unique_together': "(('consumer', 'action', 'environment'),)", 'object_name': 'ActiveAction'},
            'action': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['core.Action']"}),
            'consumer': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['core.Consumer']"}),
            'environment': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['core.Environment']"}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'})
        },
        'core.activemacros': {
            'Meta': {'unique_together': "(('consumer', 'macros', 'environment'),)", 'object_name': 'ActiveMacros'},
            'consumer': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['core.Consumer']"}),
            'environment': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['core.Environment']"}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'macros': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['core.Macros']"})
        },
        'core.activenetwork': {
            'Meta': {'unique_together': "(('consumer', 'network', 'environment'),)", 'object_name': 'ActiveNetwork'},
            'consumer': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['core.Consumer']"}),
            'environment': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['core.Environment']"}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'network': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['core.Network']"})
        },
        'core.consumer': {
            'Meta': {'unique_together': "(('name', 'namespace'),)", 'object_name': 'Consumer'},
            'description': ('django.db.models.fields.CharField', [], {'max_length': '256'}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'name': ('django.db.models.fields.CharField', [], {'max_length': '64'}),
            'namespace': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['core.Namespace']"}),
            'network': ('django.db.models.fields.related.ManyToManyField', [], {'to': "orm['core.Network']", 'symmetrical': 'False'})
        },
        'core.environment': {
            'Meta': {'object_name': 'Environment'},
            'description': ('django.db.models.fields.CharField', [], {'max_length': '256'}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'name': ('django.db.models.fields.CharField', [], {'max_length': '64'}),
            'type': ('django.db.models.fields.CharField', [], {'max_length': '64'})
        },
        'core.grant': {
            'Meta': {'unique_together': "(('name', 'namespace'),)", 'object_name': 'Grant'},
            'description': ('django.db.models.fields.CharField', [], {'max_length': '256'}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'name': ('django.db.models.fields.CharField', [], {'max_length': '64'}),
            'namespace': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['core.Namespace']"})
        },
        'core.issue': {
            'Meta': {'object_name': 'Issue'},
            'add_action': ('django.db.models.fields.related.ManyToManyField', [], {'related_name': "'add_action'", 'symmetrical': 'False', 'to': "orm['core.Action']"}),
            'add_macros': ('django.db.models.fields.related.ManyToManyField', [], {'related_name': "'add_macros'", 'symmetrical': 'False', 'to': "orm['core.Macros']"}),
            'approving_date': ('django.db.models.fields.DateTimeField', [], {'auto_now': 'True', 'blank': 'True'}),
            'approving_person': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'approving_person'", 'to': "orm['auth.User']"}),
            'consumer_and_networks': ('django.db.models.fields.CharField', [], {'max_length': '2048'}),
            'creation_date': ('django.db.models.fields.DateTimeField', [], {'auto_now_add': 'True', 'blank': 'True'}),
            'creator': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'creator'", 'to': "orm['auth.User']"}),
            'del_action': ('django.db.models.fields.related.ManyToManyField', [], {'related_name': "'del_action'", 'symmetrical': 'False', 'to': "orm['core.Action']"}),
            'del_macros': ('django.db.models.fields.related.ManyToManyField', [], {'related_name': "'del_macros'", 'symmetrical': 'False', 'to': "orm['core.Macros']"}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'status': ('django.db.models.fields.CharField', [], {'default': "'N'", 'max_length': '2'})
        },
        'core.macros': {
            'Meta': {'object_name': 'Macros'},
            'action': ('django.db.models.fields.related.ManyToManyField', [], {'to': "orm['core.Action']", 'symmetrical': 'False'}),
            'description': ('django.db.models.fields.CharField', [], {'max_length': '256'}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'name': ('django.db.models.fields.CharField', [], {'max_length': '64'})
        },
        'core.namespace': {
            'Meta': {'object_name': 'Namespace'},
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'name': ('django.db.models.fields.CharField', [], {'max_length': '64'})
        },
        'core.network': {
            'Meta': {'object_name': 'Network'},
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'string': ('django.db.models.fields.CharField', [], {'max_length': '256'})
        }
    }

    complete_apps = ['core']
