# -*- coding: utf-8 -*-
import datetime
import json
from south.db import db
from south.v2 import DataMigration
from django.db import models


class Migration(DataMigration):

    def forwards(self, orm):
        issues = orm['core.Issue'].objects.all()
        for issue in issues:
            data = json.loads(issue.consumer_and_networks)
            issue.consumer_name = data['consumer_name']
            issue.consumer_description = data['consumer_description']
            issue.networks_to_add = json.dumps(data['networks_to_add'])
            issue.networks_to_remove = json.dumps(data['networks_to_remove'])
            issue.namespace = orm['core.Namespace'].objects.get(name=data['namespace_name'])
            issue.environment = orm['core.Environment'].objects.get(id=data['environment_id'])
            issue.save()

    def backwards(self, orm):
        issues = orm['core.Issue'].objects.all()
        for issue in issues:
            issue.consumer_and_networks = json.dumps({
                'consumer_name': issue.consumer_name,
                'consumer_description': issue.consumer_description,
                'networks_to_add': issue.networks_to_add,
                'networks_to_remove': issue.networks_to_remove,
                'namespace_name': issue.namespace.name,
                'environment_id': issue.environment.id,
            })
            issue.save()

    models = {
        u'auth.group': {
            'Meta': {'object_name': 'Group'},
            u'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'name': ('django.db.models.fields.CharField', [], {'unique': 'True', 'max_length': '80'}),
            'permissions': ('django.db.models.fields.related.ManyToManyField', [], {'to': u"orm['auth.Permission']", 'symmetrical': 'False', 'blank': 'True'})
        },
        u'auth.permission': {
            'Meta': {'ordering': "(u'content_type__app_label', u'content_type__model', u'codename')", 'unique_together': "((u'content_type', u'codename'),)", 'object_name': 'Permission'},
            'codename': ('django.db.models.fields.CharField', [], {'max_length': '100'}),
            'content_type': ('django.db.models.fields.related.ForeignKey', [], {'to': u"orm['contenttypes.ContentType']"}),
            u'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'name': ('django.db.models.fields.CharField', [], {'max_length': '50'})
        },
        u'auth.user': {
            'Meta': {'object_name': 'User'},
            'date_joined': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now'}),
            'email': ('django.db.models.fields.EmailField', [], {'max_length': '75', 'blank': 'True'}),
            'first_name': ('django.db.models.fields.CharField', [], {'max_length': '30', 'blank': 'True'}),
            'groups': ('django.db.models.fields.related.ManyToManyField', [], {'to': u"orm['auth.Group']", 'symmetrical': 'False', 'blank': 'True'}),
            u'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'is_active': ('django.db.models.fields.BooleanField', [], {'default': 'True'}),
            'is_staff': ('django.db.models.fields.BooleanField', [], {'default': 'False'}),
            'is_superuser': ('django.db.models.fields.BooleanField', [], {'default': 'False'}),
            'last_login': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now'}),
            'last_name': ('django.db.models.fields.CharField', [], {'max_length': '30', 'blank': 'True'}),
            'password': ('django.db.models.fields.CharField', [], {'max_length': '128'}),
            'user_permissions': ('django.db.models.fields.related.ManyToManyField', [], {'to': u"orm['auth.Permission']", 'symmetrical': 'False', 'blank': 'True'}),
            'username': ('django.db.models.fields.CharField', [], {'unique': 'True', 'max_length': '30'})
        },
        u'contenttypes.contenttype': {
            'Meta': {'ordering': "('name',)", 'unique_together': "(('app_label', 'model'),)", 'object_name': 'ContentType', 'db_table': "'django_content_type'"},
            'app_label': ('django.db.models.fields.CharField', [], {'max_length': '100'}),
            u'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'model': ('django.db.models.fields.CharField', [], {'max_length': '100'}),
            'name': ('django.db.models.fields.CharField', [], {'max_length': '100'})
        },
        u'core.action': {
            'Meta': {'object_name': 'Action'},
            'description': ('django.db.models.fields.CharField', [], {'max_length': '256'}),
            'grant': ('django.db.models.fields.related.ForeignKey', [], {'to': u"orm['core.Grant']"}),
            u'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'name': ('django.db.models.fields.CharField', [], {'max_length': '64'})
        },
        u'core.activeaction': {
            'Meta': {'unique_together': "(('consumer', 'action', 'environment'),)", 'object_name': 'ActiveAction'},
            'action': ('django.db.models.fields.related.ForeignKey', [], {'to': u"orm['core.Action']"}),
            'consumer': ('django.db.models.fields.related.ForeignKey', [], {'to': u"orm['core.Consumer']"}),
            'environment': ('django.db.models.fields.related.ForeignKey', [], {'to': u"orm['core.Environment']"}),
            u'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'})
        },
        u'core.activemacros': {
            'Meta': {'unique_together': "(('consumer', 'macros', 'environment'),)", 'object_name': 'ActiveMacros'},
            'consumer': ('django.db.models.fields.related.ForeignKey', [], {'to': u"orm['core.Consumer']"}),
            'environment': ('django.db.models.fields.related.ForeignKey', [], {'to': u"orm['core.Environment']"}),
            u'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'macros': ('django.db.models.fields.related.ForeignKey', [], {'to': u"orm['core.Macros']"})
        },
        u'core.activenetwork': {
            'Meta': {'unique_together': "(('consumer', 'network', 'environment'),)", 'object_name': 'ActiveNetwork'},
            'consumer': ('django.db.models.fields.related.ForeignKey', [], {'to': u"orm['core.Consumer']"}),
            'environment': ('django.db.models.fields.related.ForeignKey', [], {'to': u"orm['core.Environment']"}),
            u'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'network': ('django.db.models.fields.related.ForeignKey', [], {'to': u"orm['core.Network']"})
        },
        u'core.consumer': {
            'Meta': {'unique_together': "(('name', 'namespace'),)", 'object_name': 'Consumer'},
            'description': ('django.db.models.fields.CharField', [], {'max_length': '256'}),
            u'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'name': ('django.db.models.fields.CharField', [], {'max_length': '64'}),
            'namespace': ('django.db.models.fields.related.ForeignKey', [], {'to': u"orm['core.Namespace']"})
        },
        u'core.environment': {
            'Meta': {'object_name': 'Environment'},
            'description': ('django.db.models.fields.CharField', [], {'max_length': '256'}),
            u'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'name': ('django.db.models.fields.CharField', [], {'max_length': '64'}),
            'priority': ('django.db.models.fields.IntegerField', [], {}),
            'type': ('django.db.models.fields.CharField', [], {'max_length': '64'})
        },
        u'core.grant': {
            'Meta': {'unique_together': "(('name', 'namespace'),)", 'object_name': 'Grant'},
            'description': ('django.db.models.fields.CharField', [], {'max_length': '256'}),
            u'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'name': ('django.db.models.fields.CharField', [], {'max_length': '64'}),
            'namespace': ('django.db.models.fields.related.ForeignKey', [], {'to': u"orm['core.Namespace']"})
        },
        u'core.issue': {
            'Meta': {'object_name': 'Issue'},
            'add_action': ('django.db.models.fields.related.ManyToManyField', [], {'related_name': "'add_action'", 'symmetrical': 'False', 'to': u"orm['core.Action']"}),
            'add_macros': ('django.db.models.fields.related.ManyToManyField', [], {'related_name': "'add_macros'", 'symmetrical': 'False', 'to': u"orm['core.Macros']"}),
            'approving_date': ('django.db.models.fields.DateTimeField', [], {'auto_now': 'True', 'blank': 'True'}),
            'approving_person': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'approving_person'", 'to': u"orm['auth.User']"}),
            'consumer_and_networks': ('django.db.models.fields.CharField', [], {'max_length': '2048'}),
            'consumer_description': ('django.db.models.fields.CharField', [], {'max_length': '256'}),
            'consumer_name': ('django.db.models.fields.CharField', [], {'max_length': '64'}),
            'creation_date': ('django.db.models.fields.DateTimeField', [], {'auto_now_add': 'True', 'blank': 'True'}),
            'creator': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'creator'", 'to': u"orm['auth.User']"}),
            'del_action': ('django.db.models.fields.related.ManyToManyField', [], {'related_name': "'del_action'", 'symmetrical': 'False', 'to': u"orm['core.Action']"}),
            'del_macros': ('django.db.models.fields.related.ManyToManyField', [], {'related_name': "'del_macros'", 'symmetrical': 'False', 'to': u"orm['core.Macros']"}),
            'environment': ('django.db.models.fields.related.ForeignKey', [], {'to': u"orm['core.Environment']"}),
            u'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'namespace': ('django.db.models.fields.related.ForeignKey', [], {'to': u"orm['core.Namespace']"}),
            'networks_to_add': ('django.db.models.fields.CharField', [], {'max_length': '2048'}),
            'networks_to_remove': ('django.db.models.fields.CharField', [], {'max_length': '2048'}),
            'status': ('django.db.models.fields.CharField', [], {'default': "'N'", 'max_length': '2'})
        },
        u'core.macros': {
            'Meta': {'object_name': 'Macros'},
            'action': ('django.db.models.fields.related.ManyToManyField', [], {'to': u"orm['core.Action']", 'symmetrical': 'False'}),
            'description': ('django.db.models.fields.CharField', [], {'max_length': '256'}),
            u'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'name': ('django.db.models.fields.CharField', [], {'max_length': '64'}),
            'namespace': ('django.db.models.fields.related.ForeignKey', [], {'to': u"orm['core.Namespace']"})
        },
        u'core.namespace': {
            'Meta': {'object_name': 'Namespace'},
            u'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'name': ('django.db.models.fields.CharField', [], {'max_length': '64'})
        },
        u'core.network': {
            'Meta': {'object_name': 'Network'},
            u'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'string': ('django.db.models.fields.CharField', [], {'max_length': '256'})
        }
    }

    complete_apps = ['core']
    symmetrical = True
