# -*- coding: utf-8 -*-
import datetime
from south.db import db
from south.v2 import DataMigration
from django.db import models

class Migration(DataMigration):
    depends_on = (
        ("guardian", "0005_auto__chg_field_groupobjectpermission_object_pk__chg_field_userobjectp"),
    )

    def forwards(self, orm):
        db.send_pending_create_signals()
        meta_environments = [
            {'name': 'other', 'type': 'production', 'description': 'other production', 'priority': 8},
        ]

        users = [
            {'username': 'avmm'},
            {'username': 'dyor'},
        ]

        groups = []
        for meta_environment in meta_environments:
            new_group, _ = orm['auth.Group'].objects.get_or_create(name=meta_environment['description'])
            new_environment, _ = orm['core.Environment'].objects.get_or_create(**meta_environment)
            content_type_id = orm['contenttypes.contenttype'].objects.get(model='environment', app_label='core').id
            permission_id = orm['auth.permission'].objects.get(content_type_id=content_type_id,
                                                               codename="review_environment_issue").id
            orm['guardian.groupobjectpermission'].objects.get_or_create(permission_id=permission_id,
                                                                        content_type_id=content_type_id,
                                                                        group_id=new_group.id,
                                                                        object_pk=new_environment.pk)
            groups.append(new_group)

        namespace_environments = {
            'passport': (
                ('localhost', 'development'),
                ('intranet', 'development'),
                ('localhost', 'testing'),
                ('intranet', 'testing'),
                ('localhost', 'production'),
                ('intranet', 'production'),
                ('stress', 'stress'),
            ),
            'social api': (
                ('localhost', 'production'),
                ('localhost', 'testing'),
                ('localhost', 'development'),
                ('other', 'production'),
            ),
            'social proxy': (
                ('localhost', 'production'),
                ('localhost', 'testing'),
                ('other', 'production'),
            ),
        }

        for namespace_name, environments in namespace_environments.items():
            namespace, _ = orm['core.Namespace'].objects.get_or_create(name=namespace_name)
            for name, type in environments:
                environment = orm['core.environment'].objects.get(name=name, type=type)
                namespace.environments.add(environment)

            new_group, _ = orm['auth.Group'].objects.get_or_create(name=namespace_name)

            content_type_id = orm['contenttypes.contenttype'].objects.get(model='namespace', app_label='core').id
            permission, _ = orm['auth.permission'].objects.get_or_create(content_type_id=content_type_id,
                                                                         codename='review_namespace_issue',
                                                                         name=u'Рассмотреть заявку для проекта')
            orm['guardian.groupobjectpermission'].objects.get_or_create(permission_id=permission.id,
                                                                        content_type_id=content_type_id,
                                                                        group_id=new_group.id,
                                                                        object_pk=namespace.pk)
            groups.append(new_group)

        for user in users:
            new_user, _ = orm['auth.User'].objects.get_or_create(**user)
            new_user.is_staff = True
            new_user.is_superuser = True
            new_user.save()

            for group in groups:
                new_user.groups.add(group)


    def backwards(self, orm):
        raise RuntimeError("Cannot reverse this migration.")

    models = {
        u'auth.group': {
            'Meta': {'object_name': 'Group'},
            u'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'name': ('django.db.models.fields.CharField', [], {'unique': 'True', 'max_length': '80'}),
            'permissions': ('django.db.models.fields.related.ManyToManyField', [], {'to': u"orm['auth.Permission']", 'symmetrical': 'False', 'blank': 'True'})
        },
        u'auth.permission': {
            'Meta': {'ordering': "(u'content_type__app_label', u'content_type__model', u'codename')", 'unique_together': "((u'content_type', u'codename'),)", 'object_name': 'Permission'},
            'codename': ('django.db.models.fields.CharField', [], {'max_length': '100'}),
            'content_type': ('django.db.models.fields.related.ForeignKey', [], {'to': u"orm['contenttypes.ContentType']"}),
            u'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'name': ('django.db.models.fields.CharField', [], {'max_length': '50'})
        },
        u'auth.user': {
            'Meta': {'object_name': 'User'},
            'date_joined': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now'}),
            'email': ('django.db.models.fields.EmailField', [], {'max_length': '75', 'blank': 'True'}),
            'first_name': ('django.db.models.fields.CharField', [], {'max_length': '30', 'blank': 'True'}),
            'groups': ('django.db.models.fields.related.ManyToManyField', [], {'to': u"orm['auth.Group']", 'symmetrical': 'False', 'blank': 'True'}),
            u'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'is_active': ('django.db.models.fields.BooleanField', [], {'default': 'True'}),
            'is_staff': ('django.db.models.fields.BooleanField', [], {'default': 'False'}),
            'is_superuser': ('django.db.models.fields.BooleanField', [], {'default': 'False'}),
            'last_login': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now'}),
            'last_name': ('django.db.models.fields.CharField', [], {'max_length': '30', 'blank': 'True'}),
            'password': ('django.db.models.fields.CharField', [], {'max_length': '128'}),
            'user_permissions': ('django.db.models.fields.related.ManyToManyField', [], {'to': u"orm['auth.Permission']", 'symmetrical': 'False', 'blank': 'True'}),
            'username': ('django.db.models.fields.CharField', [], {'unique': 'True', 'max_length': '30'})
        },
        u'contenttypes.contenttype': {
            'Meta': {'ordering': "('name',)", 'unique_together': "(('app_label', 'model'),)", 'object_name': 'ContentType', 'db_table': "'django_content_type'"},
            'app_label': ('django.db.models.fields.CharField', [], {'max_length': '100'}),
            u'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'model': ('django.db.models.fields.CharField', [], {'max_length': '100'}),
            'name': ('django.db.models.fields.CharField', [], {'max_length': '100'})
        },
        u'core.action': {
            'Meta': {'object_name': 'Action'},
            'description': ('django.db.models.fields.CharField', [], {'max_length': '256'}),
            'grant': ('django.db.models.fields.related.ForeignKey', [], {'to': u"orm['core.Grant']"}),
            u'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'name': ('django.db.models.fields.CharField', [], {'max_length': '64'})
        },
        u'core.activeaction': {
            'Meta': {'unique_together': "(('consumer', 'action', 'environment'),)", 'object_name': 'ActiveAction'},
            'action': ('django.db.models.fields.related.ForeignKey', [], {'to': u"orm['core.Action']"}),
            'consumer': ('django.db.models.fields.related.ForeignKey', [], {'to': u"orm['core.Consumer']"}),
            'environment': ('django.db.models.fields.related.ForeignKey', [], {'to': u"orm['core.Environment']"}),
            u'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'})
        },
        u'core.activemacros': {
            'Meta': {'unique_together': "(('consumer', 'macros', 'environment'),)", 'object_name': 'ActiveMacros'},
            'consumer': ('django.db.models.fields.related.ForeignKey', [], {'to': u"orm['core.Consumer']"}),
            'environment': ('django.db.models.fields.related.ForeignKey', [], {'to': u"orm['core.Environment']"}),
            u'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'macros': ('django.db.models.fields.related.ForeignKey', [], {'to': u"orm['core.Macros']"})
        },
        u'core.activenetwork': {
            'Meta': {'unique_together': "(('consumer', 'network', 'environment'),)", 'object_name': 'ActiveNetwork'},
            'consumer': ('django.db.models.fields.related.ForeignKey', [], {'to': u"orm['core.Consumer']"}),
            'environment': ('django.db.models.fields.related.ForeignKey', [], {'to': u"orm['core.Environment']"}),
            u'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'network': ('django.db.models.fields.related.ForeignKey', [], {'to': u"orm['core.Network']"})
        },
        u'core.consumer': {
            'Meta': {'unique_together': "(('name', 'namespace'),)", 'object_name': 'Consumer'},
            'description': ('django.db.models.fields.CharField', [], {'max_length': '256'}),
            u'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'name': ('django.db.models.fields.CharField', [], {'max_length': '64'}),
            'namespace': ('django.db.models.fields.related.ForeignKey', [], {'to': u"orm['core.Namespace']"})
        },
        u'core.environment': {
            'Meta': {'ordering': "['priority']", 'object_name': 'Environment'},
            'description': ('django.db.models.fields.CharField', [], {'max_length': '256'}),
            u'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'name': ('django.db.models.fields.CharField', [], {'max_length': '64'}),
            'priority': ('django.db.models.fields.IntegerField', [], {}),
            'type': ('django.db.models.fields.CharField', [], {'max_length': '64'})
        },
        u'core.grant': {
            'Meta': {'unique_together': "(('name', 'namespace'),)", 'object_name': 'Grant'},
            'description': ('django.db.models.fields.CharField', [], {'max_length': '256'}),
            u'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'name': ('django.db.models.fields.CharField', [], {'max_length': '64'}),
            'namespace': ('django.db.models.fields.related.ForeignKey', [], {'to': u"orm['core.Namespace']"})
        },
        u'core.issue': {
            'Meta': {'object_name': 'Issue'},
            'add_action': ('django.db.models.fields.related.ManyToManyField', [], {'related_name': "'add_action'", 'symmetrical': 'False', 'to': u"orm['core.Action']"}),
            'add_macros': ('django.db.models.fields.related.ManyToManyField', [], {'related_name': "'add_macros'", 'symmetrical': 'False', 'to': u"orm['core.Macros']"}),
            'approving_date': ('django.db.models.fields.DateTimeField', [], {'auto_now': 'True', 'blank': 'True'}),
            'approving_person': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'approving_person'", 'to': u"orm['auth.User']"}),
            'consumer': ('django.db.models.fields.related.ForeignKey', [], {'to': u"orm['core.Consumer']", 'null': 'True', 'blank': 'True'}),
            'consumer_description': ('django.db.models.fields.CharField', [], {'max_length': '256', 'null': 'True', 'blank': 'True'}),
            'consumer_name': ('django.db.models.fields.CharField', [], {'max_length': '64'}),
            'creation_date': ('django.db.models.fields.DateTimeField', [], {'auto_now_add': 'True', 'blank': 'True'}),
            'creator': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'creator'", 'to': u"orm['auth.User']"}),
            'del_action': ('django.db.models.fields.related.ManyToManyField', [], {'related_name': "'del_action'", 'symmetrical': 'False', 'to': u"orm['core.Action']"}),
            'del_macros': ('django.db.models.fields.related.ManyToManyField', [], {'related_name': "'del_macros'", 'symmetrical': 'False', 'to': u"orm['core.Macros']"}),
            'environment': ('django.db.models.fields.related.ForeignKey', [], {'to': u"orm['core.Environment']"}),
            u'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'namespace': ('django.db.models.fields.related.ForeignKey', [], {'to': u"orm['core.Namespace']"}),
            'networks_to_add': ('django.db.models.fields.CharField', [], {'max_length': '2048'}),
            'networks_to_remove': ('django.db.models.fields.CharField', [], {'max_length': '2048'}),
            'status': ('django.db.models.fields.CharField', [], {'default': "'N'", 'max_length': '2'})
        },
        u'core.macros': {
            'Meta': {'object_name': 'Macros'},
            'action': ('django.db.models.fields.related.ManyToManyField', [], {'to': u"orm['core.Action']", 'symmetrical': 'False'}),
            'description': ('django.db.models.fields.CharField', [], {'max_length': '256'}),
            u'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'name': ('django.db.models.fields.CharField', [], {'max_length': '64'}),
            'namespace': ('django.db.models.fields.related.ForeignKey', [], {'to': u"orm['core.Namespace']"})
        },
        u'core.namespace': {
            'Meta': {'ordering': "['name']", 'object_name': 'Namespace'},
            'environments': ('django.db.models.fields.related.ManyToManyField', [], {'to': u"orm['core.Environment']", 'symmetrical': 'False'}),
            u'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'name': ('django.db.models.fields.CharField', [], {'max_length': '64'})
        },
        u'core.network': {
            'Meta': {'unique_together': "(('string', 'type'),)", 'object_name': 'Network'},
            u'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'string': ('django.db.models.fields.CharField', [], {'max_length': '250'}),
            'type': ('django.db.models.fields.CharField', [], {'default': "'H'", 'max_length': '2'})
        },
        u'guardian.groupobjectpermission': {
            'Meta': {'unique_together': "([u'group', u'permission', u'object_pk'],)", 'object_name': 'GroupObjectPermission'},
            'content_type': ('django.db.models.fields.related.ForeignKey', [], {'to': u"orm['contenttypes.ContentType']"}),
            'group': ('django.db.models.fields.related.ForeignKey', [], {'to': u"orm['auth.Group']"}),
            u'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'object_pk': ('django.db.models.fields.CharField', [], {'max_length': '255'}),
            'permission': ('django.db.models.fields.related.ForeignKey', [], {'to': u"orm['auth.Permission']"})
        },
        u'guardian.userobjectpermission': {
            'Meta': {'unique_together': "([u'user', u'permission', u'object_pk'],)", 'object_name': 'UserObjectPermission'},
            'content_type': ('django.db.models.fields.related.ForeignKey', [], {'to': u"orm['contenttypes.ContentType']"}),
            u'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'object_pk': ('django.db.models.fields.CharField', [], {'max_length': '255'}),
            'permission': ('django.db.models.fields.related.ForeignKey', [], {'to': u"orm['auth.Permission']"}),
            'user': ('django.db.models.fields.related.ForeignKey', [], {'to': u"orm['auth.User']"})
        }
    }

    complete_apps = ['core']
    symmetrical = True
