# -*- coding: utf-8 -*-
import datetime
from south.db import db
from south.v2 import DataMigration
from django.db import models


class Migration(DataMigration):

    def forwards(self, orm):
        ENVIRONMENT_PREFIX = u'Окружение'
        NAMESPACE_PREFIX = u'Проект'

        db.send_pending_create_signals()

        ContentType = orm['contenttypes.contenttype']
        content_type = ContentType.objects.get(model='namespaceenvironments', app_label='core')
        content_type_id = content_type.id

        Permission = orm['auth.permission']
        permission_id = Permission.objects.get(content_type_id=content_type_id, codename="namespace_environment").id

        for user in orm['auth.User'].objects.all():
            for namespace_group in user.groups.filter(name__startswith=NAMESPACE_PREFIX):
                _, namespace_name = namespace_group.name.split(' ', 1)
                namespace = orm['core.Namespace'].objects.get(name=namespace_name)
                for environment_group in user.groups.filter(name__startswith=ENVIRONMENT_PREFIX):
                    try:
                        _, environment_name, environment_type = environment_group.name.split()
                    except ValueError as e:
                        if environment_group.name == u'Окружение rc':
                            environment_name, environment_type = 'localhost', 'rc'
                        else:
                            raise
                    environment = orm['core.Environment'].objects.get(name=environment_name, type=environment_type)

                    new_group_name = u'Права на {} {} {}'.format(namespace_name, environment_name, environment_type)
                    new_group, _ = orm['auth.Group'].objects.get_or_create(name=new_group_name)
                    try:
                        namespace_environment = orm['core.NamespaceEnvironments'].objects.get(
                            namespace=namespace,
                            environment=environment,
                        )
                    except orm['core.NamespaceEnvironments'].DoesNotExist:
                        continue
                    orm['guardian.groupobjectpermission'].objects.get_or_create(
                        permission_id=permission_id,
                        content_type_id=content_type_id,
                        group_id=new_group.id,
                        object_pk=namespace_environment.id,
                    )
                    user.groups.add(new_group)

        orm['auth.Group'].objects.filter(name__startswith=ENVIRONMENT_PREFIX).delete()
        orm['auth.Group'].objects.filter(name__startswith=NAMESPACE_PREFIX).delete()
        exportobot = orm['auth.User'].objects.create(username='exportobot')
        exportobot.is_staff = True
        exportobot.is_superuser = True
        exportobot.save()

    def backwards(self, orm):
        "Write your backwards methods here."

    models = {
        u'auth.group': {
            'Meta': {'object_name': 'Group'},
            u'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'name': ('django.db.models.fields.CharField', [], {'unique': 'True', 'max_length': '80'}),
            'permissions': ('django.db.models.fields.related.ManyToManyField', [], {'to': u"orm['auth.Permission']", 'symmetrical': 'False', 'blank': 'True'})
        },
        u'auth.permission': {
            'Meta': {'ordering': "(u'content_type__app_label', u'content_type__model', u'codename')", 'unique_together': "((u'content_type', u'codename'),)", 'object_name': 'Permission'},
            'codename': ('django.db.models.fields.CharField', [], {'max_length': '100'}),
            'content_type': ('django.db.models.fields.related.ForeignKey', [], {'to': u"orm['contenttypes.ContentType']"}),
            u'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'name': ('django.db.models.fields.CharField', [], {'max_length': '50'})
        },
        u'auth.user': {
            'Meta': {'object_name': 'User'},
            'date_joined': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now'}),
            'email': ('django.db.models.fields.EmailField', [], {'max_length': '75', 'blank': 'True'}),
            'first_name': ('django.db.models.fields.CharField', [], {'max_length': '30', 'blank': 'True'}),
            'groups': ('django.db.models.fields.related.ManyToManyField', [], {'to': u"orm['auth.Group']", 'symmetrical': 'False', 'blank': 'True'}),
            u'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'is_active': ('django.db.models.fields.BooleanField', [], {'default': 'True'}),
            'is_staff': ('django.db.models.fields.BooleanField', [], {'default': 'False'}),
            'is_superuser': ('django.db.models.fields.BooleanField', [], {'default': 'False'}),
            'last_login': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now'}),
            'last_name': ('django.db.models.fields.CharField', [], {'max_length': '30', 'blank': 'True'}),
            'password': ('django.db.models.fields.CharField', [], {'max_length': '128'}),
            'user_permissions': ('django.db.models.fields.related.ManyToManyField', [], {'to': u"orm['auth.Permission']", 'symmetrical': 'False', 'blank': 'True'}),
            'username': ('django.db.models.fields.CharField', [], {'unique': 'True', 'max_length': '30'})
        },
        u'contenttypes.contenttype': {
            'Meta': {'ordering': "('name',)", 'unique_together': "(('app_label', 'model'),)", 'object_name': 'ContentType', 'db_table': "'django_content_type'"},
            'app_label': ('django.db.models.fields.CharField', [], {'max_length': '100'}),
            u'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'model': ('django.db.models.fields.CharField', [], {'max_length': '100'}),
            'name': ('django.db.models.fields.CharField', [], {'max_length': '100'})
        },
        u'core.action': {
            'Meta': {'ordering': "['grant', 'name']", 'unique_together': "(('name', 'grant'),)", 'object_name': 'Action'},
            'dangerous': ('django.db.models.fields.BooleanField', [], {'default': 'False'}),
            'description': ('django.db.models.fields.CharField', [], {'max_length': '256'}),
            'grant': ('django.db.models.fields.related.ForeignKey', [], {'to': u"orm['core.Grant']"}),
            u'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'name': ('django.db.models.fields.CharField', [], {'default': "'*'", 'max_length': '64'})
        },
        u'core.activeaction': {
            'Meta': {'unique_together': "(('consumer', 'action', 'environment'),)", 'object_name': 'ActiveAction'},
            'action': ('django.db.models.fields.related.ForeignKey', [], {'to': u"orm['core.Action']"}),
            'consumer': ('django.db.models.fields.related.ForeignKey', [], {'to': u"orm['core.Consumer']"}),
            'environment': ('django.db.models.fields.related.ForeignKey', [], {'to': u"orm['core.Environment']"}),
            'expiration': ('django.db.models.fields.DateField', [], {'null': 'True', 'blank': 'True'}),
            u'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'})
        },
        u'core.activemacros': {
            'Meta': {'unique_together': "(('consumer', 'macros', 'environment'),)", 'object_name': 'ActiveMacros'},
            'consumer': ('django.db.models.fields.related.ForeignKey', [], {'to': u"orm['core.Consumer']"}),
            'environment': ('django.db.models.fields.related.ForeignKey', [], {'to': u"orm['core.Environment']"}),
            'expiration': ('django.db.models.fields.DateField', [], {'null': 'True', 'blank': 'True'}),
            u'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'macros': ('django.db.models.fields.related.ForeignKey', [], {'to': u"orm['core.Macros']"})
        },
        u'core.activenetwork': {
            'Meta': {'unique_together': "(('consumer', 'network', 'environment'),)", 'object_name': 'ActiveNetwork'},
            'consumer': ('django.db.models.fields.related.ForeignKey', [], {'to': u"orm['core.Consumer']"}),
            'environment': ('django.db.models.fields.related.ForeignKey', [], {'to': u"orm['core.Environment']"}),
            u'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'network': ('django.db.models.fields.related.ForeignKey', [], {'to': u"orm['core.Network']"})
        },
        u'core.addnetworks': {
            'Meta': {'unique_together': "(('issue', 'network', 'environment'),)", 'object_name': 'AddNetworks'},
            'environment': ('django.db.models.fields.related.ForeignKey', [], {'to': u"orm['core.Environment']"}),
            u'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'issue': ('django.db.models.fields.related.ForeignKey', [], {'to': u"orm['core.Issue']"}),
            'network': ('django.db.models.fields.related.ForeignKey', [], {'to': u"orm['core.Network']"})
        },
        u'core.consumer': {
            'Meta': {'ordering': "['name']", 'unique_together': "(('name', 'namespace'),)", 'object_name': 'Consumer'},
            'description': ('django.db.models.fields.CharField', [], {'max_length': '256'}),
            u'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'name': ('django.db.models.fields.CharField', [], {'max_length': '64'}),
            'namespace': ('django.db.models.fields.related.ForeignKey', [], {'to': u"orm['core.Namespace']"})
        },
        u'core.delnetworks': {
            'Meta': {'unique_together': "(('issue', 'network', 'environment'),)", 'object_name': 'DelNetworks'},
            'environment': ('django.db.models.fields.related.ForeignKey', [], {'to': u"orm['core.Environment']"}),
            u'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'issue': ('django.db.models.fields.related.ForeignKey', [], {'to': u"orm['core.Issue']"}),
            'network': ('django.db.models.fields.related.ForeignKey', [], {'to': u"orm['core.Network']"})
        },
        u'core.environment': {
            'Meta': {'ordering': "['priority']", 'object_name': 'Environment'},
            'description': ('django.db.models.fields.CharField', [], {'max_length': '256'}),
            u'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'name': ('django.db.models.fields.CharField', [], {'max_length': '64'}),
            'priority': ('django.db.models.fields.IntegerField', [], {}),
            'type': ('django.db.models.fields.CharField', [], {'max_length': '64'})
        },
        u'core.grant': {
            'Meta': {'ordering': "['namespace', 'name']", 'unique_together': "(('name', 'namespace'),)", 'object_name': 'Grant'},
            'description': ('django.db.models.fields.CharField', [], {'max_length': '256', 'blank': 'True'}),
            u'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'name': ('django.db.models.fields.CharField', [], {'max_length': '64'}),
            'namespace': ('django.db.models.fields.related.ForeignKey', [], {'to': u"orm['core.Namespace']"})
        },
        u'core.issue': {
            'Meta': {'ordering': "['-creation_date']", 'object_name': 'Issue'},
            'add_action': ('django.db.models.fields.related.ManyToManyField', [], {'symmetrical': 'False', 'related_name': "'issue_add'", 'blank': 'True', 'to': u"orm['core.Action']"}),
            'add_macros': ('django.db.models.fields.related.ManyToManyField', [], {'symmetrical': 'False', 'related_name': "'issue_add'", 'blank': 'True', 'to': u"orm['core.Macros']"}),
            'add_network': ('django.db.models.fields.related.ManyToManyField', [], {'symmetrical': 'False', 'related_name': "'issue_add'", 'blank': 'True', 'through': u"orm['core.AddNetworks']", 'to': u"orm['core.Network']"}),
            'approving_date': ('django.db.models.fields.DateTimeField', [], {'auto_now': 'True', 'blank': 'True'}),
            'approving_person': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'approving_person'", 'blank': 'True', 'to': u"orm['auth.User']"}),
            'consumer': ('django.db.models.fields.related.ForeignKey', [], {'to': u"orm['core.Consumer']", 'null': 'True', 'blank': 'True'}),
            'consumer_description': ('django.db.models.fields.CharField', [], {'max_length': '256', 'blank': 'True'}),
            'consumer_name': ('django.db.models.fields.CharField', [], {'max_length': '64', 'blank': 'True'}),
            'consumer_name_new': ('django.db.models.fields.CharField', [], {'max_length': '64', 'blank': 'True'}),
            'creation_date': ('django.db.models.fields.DateTimeField', [], {'auto_now_add': 'True', 'blank': 'True'}),
            'creator': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'creator'", 'to': u"orm['auth.User']"}),
            'del_action': ('django.db.models.fields.related.ManyToManyField', [], {'symmetrical': 'False', 'related_name': "'issue_del'", 'blank': 'True', 'to': u"orm['core.Action']"}),
            'del_macros': ('django.db.models.fields.related.ManyToManyField', [], {'symmetrical': 'False', 'related_name': "'issue_del'", 'blank': 'True', 'to': u"orm['core.Macros']"}),
            'del_network': ('django.db.models.fields.related.ManyToManyField', [], {'symmetrical': 'False', 'related_name': "'issue_del'", 'blank': 'True', 'through': u"orm['core.DelNetworks']", 'to': u"orm['core.Network']"}),
            'environments': ('django.db.models.fields.related.ManyToManyField', [], {'related_name': "'environments'", 'symmetrical': 'False', 'to': u"orm['core.Environment']"}),
            'expiration': ('django.db.models.fields.DateField', [], {'null': 'True', 'blank': 'True'}),
            u'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'namespace': ('django.db.models.fields.related.ForeignKey', [], {'to': u"orm['core.Namespace']"}),
            'status': ('django.db.models.fields.CharField', [], {'default': "'N'", 'max_length': '2'}),
            'type': ('django.db.models.fields.CharField', [], {'default': "'M'", 'max_length': '2'})
        },
        u'core.macros': {
            'Meta': {'ordering': "['namespace', 'name']", 'unique_together': "(('name', 'namespace'),)", 'object_name': 'Macros'},
            'action': ('django.db.models.fields.related.ManyToManyField', [], {'to': u"orm['core.Action']", 'symmetrical': 'False'}),
            'description': ('django.db.models.fields.CharField', [], {'max_length': '256', 'blank': 'True'}),
            u'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'name': ('django.db.models.fields.CharField', [], {'max_length': '64'}),
            'namespace': ('django.db.models.fields.related.ForeignKey', [], {'to': u"orm['core.Namespace']"})
        },
        u'core.namespace': {
            'Meta': {'ordering': "['name']", 'object_name': 'Namespace'},
            'environments': ('django.db.models.fields.related.ManyToManyField', [], {'to': u"orm['core.Environment']", 'through': u"orm['core.NamespaceEnvironments']", 'symmetrical': 'False'}),
            u'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'name': ('django.db.models.fields.CharField', [], {'max_length': '64'})
        },
        u'core.namespaceenvironments': {
            'Meta': {'unique_together': "(('namespace', 'environment'),)", 'object_name': 'NamespaceEnvironments', 'db_table': "'core_namespace_environments'"},
            'environment': ('django.db.models.fields.related.ForeignKey', [], {'to': u"orm['core.Environment']"}),
            u'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'namespace': ('django.db.models.fields.related.ForeignKey', [], {'to': u"orm['core.Namespace']"})
        },
        u'core.network': {
            'Meta': {'unique_together': "(('string', 'type'),)", 'object_name': 'Network'},
            u'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'string': ('django.db.models.fields.CharField', [], {'max_length': '250'}),
            'type': ('django.db.models.fields.CharField', [], {'default': "'H'", 'max_length': '2'})
        },
        u'core.timestamp': {
            'Meta': {'object_name': 'Timestamp'},
            u'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'name': ('django.db.models.fields.CharField', [], {'max_length': '32'}),
            'time': ('django.db.models.fields.DateTimeField', [], {'auto_now': 'True', 'blank': 'True'})
        },
        u'guardian.groupobjectpermission': {
            'Meta': {'unique_together': "([u'group', u'permission', u'object_pk'],)", 'object_name': 'GroupObjectPermission'},
            'content_type': ('django.db.models.fields.related.ForeignKey', [], {'to': u"orm['contenttypes.ContentType']"}),
            'group': ('django.db.models.fields.related.ForeignKey', [], {'to': u"orm['auth.Group']"}),
            u'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'object_pk': ('django.db.models.fields.CharField', [], {'max_length': '255'}),
            'permission': ('django.db.models.fields.related.ForeignKey', [], {'to': u"orm['auth.Permission']"})
        },
        u'guardian.userobjectpermission': {
            'Meta': {'unique_together': "([u'user', u'permission', u'object_pk'],)", 'object_name': 'UserObjectPermission'},
            'content_type': ('django.db.models.fields.related.ForeignKey', [], {'to': u"orm['contenttypes.ContentType']"}),
            u'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'object_pk': ('django.db.models.fields.CharField', [], {'max_length': '255'}),
            'permission': ('django.db.models.fields.related.ForeignKey', [], {'to': u"orm['auth.Permission']"}),
            'user': ('django.db.models.fields.related.ForeignKey', [], {'to': u"orm['auth.User']"})
        }
    }

    complete_apps = ['guardian', 'core']
    symmetrical = True
